/*
Licensed Materials - Property of IBM
5900-A2A
© Copyright IBM Corporation 2020. All Rights Reserved.
This sample program is provided AS IS and may be used, executed, copied and modified without royalty payment by customer
(a) for its own instruction and study, (b) in order to develop applications designed to run with an IBM product,
either for customer's own internal use or for redistribution by customer, as part of such an application, in customer's
own products.
*/


package services;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ConfigServices {

	private static Properties defaultProps = new Properties();
	
	static {

		String propFile = System.getProperty("PROP_FILE");

		if(propFile == null || propFile.isEmpty()){

			try (InputStream prop = ConfigServices.class.getClassLoader().getResourceAsStream("testjar/config.properties")) {
				defaultProps.load(prop);
			} catch (IOException e) {
				System.out.println("Failed to load properties file: " +e);
			}

		} else{

			try (InputStream prop = new FileInputStream(propFile)) {
				defaultProps.load(prop);
			} catch (IOException e) {
				System.out.println("Failed to load properties file: " +e);
			}
		}


	}

	public static String getProperty(String key) {
		return defaultProps.getProperty(key);
	}
}



