/*
Licensed Materials - Property of IBM
5900-A2A
© Copyright IBM Corporation 2020. All Rights Reserved.
This sample program is provided AS IS and may be used, executed, copied and modified without royalty payment by customer
(a) for its own instruction and study, (b) in order to develop applications designed to run with an IBM product,
either for customer's own internal use or for redistribution by customer, as part of such an application, in customer's
own products.
*/


package accessmanagement;

import model.Group;
import model.Member;
import model.User;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

public class LDIFParser {

	File lidfFile;

	
	public LDIFParser (File ldifFile) 
	{
		this.lidfFile = ldifFile;
	}
	

	
	public void convert()  throws FileNotFoundException
	{
		try
		{
			ArrayList<String> linesFromLDIF = this.getLines();
			
			ArrayList<User> users = new ArrayList<User>();
			ArrayList<Group> groups = new ArrayList<Group>();
			String groupname = null;
			String uid = null;
			List<Member> userGroup = new ArrayList<Member>();
		
			Group group = null;
			for (int i = 0; i < linesFromLDIF.size(); i++) 
			{
				String line = linesFromLDIF.get(i);
				
				if (line.contains("dn")) 
				{
					if(line.contains("uid")) {
						String[] lineParts = line.split(":");
						String val = lineParts[1];
						val = val.replaceAll("\\s+","");
						String[] userStr = val.split(",");
						String userData = userStr[0];
						String[] uidMap = userData.split("=");
						uid = uidMap[1];
						User user = new User();
						user.setUserId(uid);
						user.setEmail(uid);
						user.setBaseDn("cn=users,O=IBM,C=US");
						users.add(user);

					} else if(line.contains("groups")){
						if (userGroup.size() >0) {							
							group.setName(groupname);
							group.setBase_dn("cn=groups,O=IBM,C=US");
							group.setMembers(userGroup);
							groups.add(group);
							
						}
						String[] lineParts = line.split(":");
						String val = lineParts[1];
						val = val.replaceAll("\\s+","");
						String[] groupStr = val.split(",");
						String groupData = groupStr[0];
						String[] groupMap = groupData.split("=");
						groupname = groupMap[1];
						group = new Group();
						userGroup = new ArrayList<Member>();
											
					}
				} else if(line.contains("member")) {
					String[] lineParts = line.split(":");
					String val = lineParts[1];
					val = val.replaceAll("\\s+","");
					String[] userStr = val.split(",");
					String userData = userStr[0];
					String[] uidMap = userData.split("=");
					uid = uidMap[1];
					if(uidMap[0].contains("uid")) {
						Member member = new Member();
						member.setMember_id(uid);
						member.setType("user");
						member.setBase_dn("cn=users,O=IBM,C=US");
						userGroup.add(member);
					}else if(uidMap[0].contains("cn")){
						Member member = new Member();
						member.setMember_id(uid);
						member.setType("group");
						member.setBase_dn("cn=groups,O=IBM,C=US");
						userGroup.add(member);
					}
				}
			}
			
			if (userGroup.size() >0) {
				group.setName(groupname);
				group.setBase_dn("cn=groups,O=IBM,C=US");
				group.setMembers(userGroup);
				groups.add(group);
			}
			
			ManageUsers manageUsers = new ManageUsers();
			ManageGroups manageGroups = new ManageGroups();

			manageUsers.createUsers(users);
			manageGroups.createGroups(groups);
			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public ArrayList<String> getLines() throws FileNotFoundException {
		ArrayList<String> lines = new ArrayList<String>();
		try 
		{
			FileReader file = new FileReader(this.lidfFile);
			BufferedReader bufReader = new BufferedReader(file);
			String line;
			while ((line = bufReader.readLine()) != null) {
				lines.add(line);
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			throw e;
		} catch (IOException e) {
			e.printStackTrace();
		}
		return lines;
	}
	

//	public static void main(String[] args) {
//
////			String inputfile = "ldifsample.ldif";
//
//	}
}
