/*
Licensed Materials - Property of IBM
5900-A2A
© Copyright IBM Corporation 2020. All Rights Reserved.
This sample program is provided AS IS and may be used, executed, copied and modified without royalty payment by customer
(a) for its own instruction and study, (b) in order to develop applications designed to run with an IBM product,
either for customer's own internal use or for redistribution by customer, as part of such an application, in customer's
own products.
*/


package accessmanagement;

import model.Group;
import services.ConfigServices;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;

public class AccessManagement {

	public static void main(String[] args) {
		Scanner myObj = new Scanner(System.in);

	    ManageUsers users = new ManageUsers();
	    ManageGroups manageGroups = new ManageGroups();
	    boolean run = true;
	    while(run) {
	    	System.out.println("Select one option from below operations:\n 1. Create a user \n 2. Update a user \n 3. Delete a user \n 4. Create a group \n 5. Update a group \n 6. Delete a group \n 7. Create user or group by LDIF file \n 8. Exit");
	    	System.out.println();
			String userInput = myObj.nextLine();
	    switch (userInput) {
	      case "1":
	      	System.out.println();
	        System.out.println("Enter UID(email) to be provisioned: ");
	        System.out.println();
	        String userToCreate = myObj.nextLine();
	        users.createUser(userToCreate);
	        break;
	      case "2":
	      	System.out.println();
	        System.out.println("Enter UID(email) of the user to be updated : ");
	        System.out.println();
	        String userToUpdate = myObj.nextLine();

	        System.out.println("Enter familyname: ");
	        System.out.println();
	        String familynameToUpdate = myObj.nextLine();

	        System.out.println("Enter givenname: ");
	        System.out.println();
	        String givennameToUpdate = myObj.nextLine();

	        System.out.println("Enter preferred language: ");
	        System.out.println();
	        String languageToUpdate = myObj.nextLine();

	        System.out.println("Enter a group name to add to the user: ");
	        System.out.println();
	        String usergroupToUpdate = myObj.nextLine();

	        users.updateUser(userToUpdate, givennameToUpdate, familynameToUpdate,languageToUpdate,usergroupToUpdate);
	        break;
	      case "3":
	      	System.out.println();
	    	System.out.println("Enter UID(email) of the user to be deleted : ");
	    	System.out.println();
	    	String userToDelete = myObj.nextLine();

	    	users.deleteUser(userToDelete);
	        break;
	      case "4":
	      	System.out.println();
	        System.out.println("Enter the group name to be created :" );
	        System.out.println();
	        String groupToCreate = myObj.nextLine();
	        Group group = new Group();
	        group.setName(groupToCreate);
	        manageGroups.createGroup(group);
	        break;
	      case "5":
	    	  System.out.println();
	    	 System.out.println("Enter the group name to be updated : ");
	    	 System.out.println();
	    	 String groupToUpdate = myObj.nextLine();

	    	 System.out.println("Enter UID(email) of the user to add to the group : ");
	    	 System.out.println();
	    	 String userToGroupUpdate = myObj.nextLine();

	    	 manageGroups.updateGroup(groupToUpdate, userToGroupUpdate);
	    	 
	        break;
	      case "6":
	      	 System.out.println();
	    	 System.out.println("Enter group name to be deleted : ");
	    	 System.out.println();
	    	 String groupToDelete = myObj.nextLine();

	    	 manageGroups.deleteGroup(groupToDelete);
	        break;
	        case "7":
				System.out.println();
				String pathToLDIFFile = ConfigServices.getProperty("PathToLDIFFile");
				System.out.println("Fetching the ldif file path from config.properties...");
				LDIFParser ldifConverter = new LDIFParser(new File(pathToLDIFFile));
				try {
					ldifConverter.convert();
				} catch (FileNotFoundException e) {
					e.printStackTrace();
					System.out.println("LDIF File not found");
				}
				System.out.println();

				break;
	      case "8":
	    	  System.out.println();
	    	  System.out.println("Exit");
	    	  System.out.println();
	    	  myObj.close();
	    	  run = false;
	    	  break;
	    }
	    }
	}

}
