/*
 * Decompiled with CFR 0.152.
 */
package accessmanagement;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import model.Details;
import model.Groups;
import model.User;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.json.JSONObject;
import services.ConfigServices;

public class ManageUsers {
    private static String csrf_token;
    private static HttpClient client;

    public static void main(String[] args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateCSRF() {
        HttpPost post = null;
        try {
            String url = ConfigServices.getProperty("Url") + ConfigServices.getProperty("CSRFTokenEndpoint");
            String data = "{\"requested_lifetime\":7200}";
            post = new HttpPost(url);
            if (data != null) {
                post.setEntity((HttpEntity)new StringEntity(data));
                post.addHeader("Authorization", ConfigServices.getProperty("AuthorizationBearerToken"));
                post.addHeader("Content-Type", "application/json");
            }
            ObjectMapper mapper = new ObjectMapper();
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            Map map = (Map)mapper.readValue(response.getEntity().getContent(), Map.class);
            csrf_token = (String)map.get("csrf_token");
        }
        catch (Exception e) {
            System.out.println(e);
        }
        finally {
            post.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createUser(String user_id) {
        User user = new User();
        user.setUserId(user_id);
        user.setBaseDn("cn=users,O=IBM,C=US");
        user.setEmail(user_id);
        ArrayList<Groups> usergroup = new ArrayList<Groups>();
        Groups grp = new Groups();
        grp.setName("Developers");
        grp.setBase_dn("cn=groups,O=IBM,C=US");
        usergroup.add(grp);
        user.setGroups(usergroup);
        ObjectMapper mapper = new ObjectMapper();
        String data = "";
        try {
            data = mapper.writeValueAsString((Object)user);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        ManageUsers.generateCSRF();
        String url = ConfigServices.getProperty("Url") + ConfigServices.getProperty("UserEndpoint");
        HttpPost post = new HttpPost(url);
        try {
            if (data != null) {
                post.setEntity((HttpEntity)new StringEntity(data));
                post.addHeader("Authorization", ConfigServices.getProperty("AuthorizationBearerToken"));
                post.addHeader("Content-Type", "application/json");
                post.addHeader("IBM-CSRF-TOKEN", csrf_token);
            }
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            Map map = (Map)mapper.readValue(response.getEntity().getContent(), Map.class);
            if (response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 300) {
                System.out.println("User " + map + "created successfully");
            } else {
                System.out.println("Error creating the user /n");
                if (map != null) {
                    System.out.println(map.get("error_message"));
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        finally {
            post.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createUsers(List users) {
        ObjectMapper mapper = new ObjectMapper();
        String data = "";
        HashMap<String, List> mapUser = new HashMap<String, List>();
        mapUser.put("users", users);
        String usersString = "";
        try {
            usersString = mapper.writeValueAsString(mapUser);
        }
        catch (JsonProcessingException e1) {
            e1.printStackTrace();
        }
        ManageUsers.generateCSRF();
        data = usersString;
        String url = ConfigServices.getProperty("Url") + ConfigServices.getProperty("CreateBulkUsersEndpoint");
        HttpPost post = new HttpPost(url);
        try {
            if (data != null) {
                post.setEntity((HttpEntity)new StringEntity(data));
                post.addHeader("Authorization", ConfigServices.getProperty("AuthorizationBearerToken"));
                post.addHeader("Content-Type", "application/json");
                post.addHeader("IBM-CSRF-TOKEN", csrf_token);
            }
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            Map map = (Map)mapper.readValue(response.getEntity().getContent(), Map.class);
            if (response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 300) {
                System.out.println("User " + map + "created");
            } else {
                System.out.println("Error creating the user /n");
                if (map != null) {
                    System.out.println(map.get("error_message"));
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        finally {
            post.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateUser(String user_id, String given_name, String family_name, String preferred_language, String group_name) {
        String url = ConfigServices.getProperty("Url") + ConfigServices.getProperty("UserEndpoint") + "/" + user_id + "?update_mode=merge";
        ManageUsers.generateCSRF();
        JSONObject jsonObj = new JSONObject();
        Details details = new Details();
        details.setPreferredLanguage(preferred_language);
        ArrayList<Groups> userGroupList = new ArrayList<Groups>();
        Groups userGroup = new Groups();
        userGroup.setName(group_name);
        userGroup.setBase_dn("cn=groups,O=IBM,C=US");
        userGroupList.add(userGroup);
        User user = new User();
        user.setGivenName(given_name);
        user.setFamilyName(family_name);
        user.setDetails(details);
        user.setGroups(userGroupList);
        ObjectMapper mapper = new ObjectMapper();
        String data = "";
        try {
            data = mapper.writeValueAsString((Object)user);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        HttpPut put = new HttpPut(url);
        try {
            ManageUsers.generateCSRF();
            if (data != null) {
                put.setEntity((HttpEntity)new StringEntity(data));
                put.addHeader("Authorization", ConfigServices.getProperty("AuthorizationBearerToken"));
                put.addHeader("Content-Type", "application/json");
                put.addHeader("IBM-CSRF-TOKEN", csrf_token);
            }
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)put);
            Map map = (Map)mapper.readValue(response.getEntity().getContent(), Map.class);
            if (response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 300) {
                System.out.println("User " + map + "updated successfully");
            } else {
                System.out.println("Error updating the user /n");
                if (map != null) {
                    System.out.println(map.get("error_message"));
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        finally {
            put.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteUser(String uid) {
        String url = ConfigServices.getProperty("Url") + ConfigServices.getProperty("UserEndpoint") + "/" + uid;
        HttpDelete delete = new HttpDelete(url);
        try {
            ManageUsers.generateCSRF();
            delete.addHeader("Authorization", ConfigServices.getProperty("AuthorizationBearerToken"));
            delete.addHeader("Content-Type", "application/json");
            delete.addHeader("IBM-CSRF-TOKEN", csrf_token);
            ObjectMapper mapper = new ObjectMapper();
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)delete);
            if (response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 300) {
                System.out.println("User deleted successfully");
            } else {
                System.out.println("Error deleting the user : /n");
                Map map = (Map)mapper.readValue(response.getEntity().getContent(), Map.class);
                if (map != null) {
                    System.out.println(map.get("error_message"));
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        finally {
            delete.abort();
        }
    }
}

