/*
 * Decompiled with CFR 0.152.
 */
package accessmanagement;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import model.Group;
import model.Member;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import services.ConfigServices;

public class ManageGroups {
    private static String csrf_token;

    public static void main(String[] args) {
        ManageGroups.generateCSRF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateCSRF() {
        String url = ConfigServices.getProperty("Url") + ConfigServices.getProperty("CSRFTokenEndpoint");
        String data = "{\"requested_lifetime\":7200}";
        HttpPost post = new HttpPost(url);
        try {
            if (data != null) {
                post.setEntity((HttpEntity)new StringEntity(data));
                post.addHeader("Authorization", ConfigServices.getProperty("AuthorizationBearerToken"));
                post.addHeader("Content-Type", "application/json");
            }
            ObjectMapper mapper = new ObjectMapper();
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            Map map = (Map)mapper.readValue(response.getEntity().getContent(), Map.class);
            csrf_token = (String)map.get("csrf_token");
        }
        catch (Exception e) {
            System.out.println(e);
        }
        finally {
            post.abort();
        }
    }

    void createGroups(List<Group> groups) {
        for (Group group : groups) {
            this.createGroup(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createGroup(Group group) {
        ObjectMapper mapper = new ObjectMapper();
        String data = "";
        try {
            data = mapper.writeValueAsString((Object)group);
        }
        catch (JsonProcessingException e1) {
            e1.printStackTrace();
        }
        ManageGroups.generateCSRF();
        String url = ConfigServices.getProperty("Url") + ConfigServices.getProperty("GroupEndpoint");
        HttpPost post = new HttpPost(url);
        try {
            if (data != null) {
                post.setEntity((HttpEntity)new StringEntity(data));
                post.addHeader("Authorization", ConfigServices.getProperty("AuthorizationBearerToken"));
                post.addHeader("Content-Type", "application/json");
                post.addHeader("IBM-CSRF-TOKEN", csrf_token);
            }
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            Map map = (Map)mapper.readValue(response.getEntity().getContent(), Map.class);
            if (response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 300) {
                System.out.println("Group created " + map);
            } else {
                System.out.println("Error creating group  ");
                if (map != null) {
                    System.out.println(map.get("error_message"));
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        finally {
            post.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateGroup(String groupToUpdate, String userToGroupUpdate) {
        String url = ConfigServices.getProperty("Url") + ConfigServices.getProperty("GroupEndpoint") + "/" + groupToUpdate + "/members";
        ArrayList<Member> userGroup = new ArrayList<Member>();
        Member member = new Member();
        member.setMember_id(userToGroupUpdate);
        member.setType("user");
        member.setBase_dn("cn=users,O=IBM,C=US");
        userGroup.add(member);
        Group grp = new Group();
        grp.setMembers(userGroup);
        ManageGroups.generateCSRF();
        ObjectMapper mapper = new ObjectMapper();
        String data = "";
        try {
            data = mapper.writeValueAsString((Object)grp);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        HttpPut put = new HttpPut(url);
        try {
            if (data != null) {
                put.setEntity((HttpEntity)new StringEntity(data));
                put.addHeader("Authorization", ConfigServices.getProperty("AuthorizationBearerToken"));
                put.addHeader("Content-Type", "application/json");
                put.addHeader("IBM-CSRF-TOKEN", csrf_token);
            }
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)put);
            Map map = (Map)mapper.readValue(response.getEntity().getContent(), Map.class);
            if (response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 300) {
                System.out.println("Group " + map + "updated successfully");
            } else {
                System.out.println("Error updating the group");
                if (map != null) {
                    System.out.println(map.get("error_message"));
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        finally {
            put.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteGroup(String groupToDelete) {
        String url = ConfigServices.getProperty("Url") + ConfigServices.getProperty("GroupEndpoint") + "/" + groupToDelete;
        ManageGroups.generateCSRF();
        HttpDelete delete = new HttpDelete(url);
        try {
            delete.addHeader("Authorization", ConfigServices.getProperty("AuthorizationBearerToken"));
            delete.addHeader("Content-Type", "application/json");
            delete.addHeader("IBM-CSRF-TOKEN", csrf_token);
            ObjectMapper mapper = new ObjectMapper();
            CloseableHttpClient httpClient = HttpClients.createDefault();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)delete);
            if (response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 300) {
                System.out.println("Group deleted successfully");
            } else {
                System.out.println("Error deleting the group  /n");
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        finally {
            delete.abort();
        }
    }
}

