/*
 * Decompiled with CFR 0.152.
 */
package accessmanagement;

import accessmanagement.ManageGroups;
import accessmanagement.ManageUsers;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import model.Group;
import model.Member;
import model.User;

public class LDIFParser {
    File lidfFile;

    public LDIFParser(File ldifFile) {
        this.lidfFile = ldifFile;
    }

    public void convert() throws FileNotFoundException {
        try {
            ArrayList<String> linesFromLDIF = this.getLines();
            ArrayList<User> users = new ArrayList<User>();
            ArrayList<Group> groups = new ArrayList<Group>();
            String groupname = null;
            String uid = null;
            ArrayList<Member> userGroup = new ArrayList<Member>();
            Group group = null;
            for (int i = 0; i < linesFromLDIF.size(); ++i) {
                Member member;
                String[] uidMap;
                String userData;
                String[] userStr;
                String val;
                String[] lineParts;
                String line = linesFromLDIF.get(i);
                if (line.contains("dn")) {
                    if (line.contains("uid")) {
                        lineParts = line.split(":");
                        val = lineParts[1];
                        val = val.replaceAll("\\s+", "");
                        userStr = val.split(",");
                        userData = userStr[0];
                        uidMap = userData.split("=");
                        uid = uidMap[1];
                        User user = new User();
                        user.setUserId(uid);
                        user.setEmail(uid);
                        user.setBaseDn("cn=users,O=IBM,C=US");
                        users.add(user);
                        continue;
                    }
                    if (!line.contains("groups")) continue;
                    if (userGroup.size() > 0) {
                        group.setName(groupname);
                        group.setBase_dn("cn=groups,O=IBM,C=US");
                        group.setMembers(userGroup);
                        groups.add(group);
                    }
                    lineParts = line.split(":");
                    val = lineParts[1];
                    val = val.replaceAll("\\s+", "");
                    String[] groupStr = val.split(",");
                    String groupData = groupStr[0];
                    String[] groupMap = groupData.split("=");
                    groupname = groupMap[1];
                    group = new Group();
                    userGroup = new ArrayList();
                    continue;
                }
                if (!line.contains("member")) continue;
                lineParts = line.split(":");
                val = lineParts[1];
                val = val.replaceAll("\\s+", "");
                userStr = val.split(",");
                userData = userStr[0];
                uidMap = userData.split("=");
                uid = uidMap[1];
                if (uidMap[0].contains("uid")) {
                    member = new Member();
                    member.setMember_id(uid);
                    member.setType("user");
                    member.setBase_dn("cn=users,O=IBM,C=US");
                    userGroup.add(member);
                    continue;
                }
                if (!uidMap[0].contains("cn")) continue;
                member = new Member();
                member.setMember_id(uid);
                member.setType("group");
                member.setBase_dn("cn=groups,O=IBM,C=US");
                userGroup.add(member);
            }
            if (userGroup.size() > 0) {
                group.setName(groupname);
                group.setBase_dn("cn=groups,O=IBM,C=US");
                group.setMembers(userGroup);
                groups.add(group);
            }
            ManageUsers manageUsers = new ManageUsers();
            ManageGroups manageGroups = new ManageGroups();
            manageUsers.createUsers(users);
            manageGroups.createGroups(groups);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<String> getLines() throws FileNotFoundException {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            FileReader file = new FileReader(this.lidfFile);
            BufferedReader bufReader = new BufferedReader(file);
            while ((line = bufReader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lines;
    }
}

