/*
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5725A15
 * 
 *  Copyright IBM Corp. 2011
 * 
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 */
package com.ibm.casemgmt.sampexterndata.rest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.filenet.api.core.Connection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.ibm.casemgmt.sampexterndata.api.SEDConstants;
import com.ibm.casemgmt.sampexterndata.api.SEDException;
import com.ibm.casemgmt.sampexterndata.api.ExternalProperty;
import com.ibm.casemgmt.sampexterndata.api.ExternalRequestMode;
import com.ibm.casemgmt.sampexterndata.api.ExternalSystemConfiguration;
import com.ibm.casemgmt.sampexterndata.api.InputProperty;
import com.ibm.casemgmt.sampexterndata.api.SEDLogger;


final class SampleServiceHandler
{

	private static final Log logger = LogFactory.getLog(RESTConstants.LOGGER_SAMPLE_SERVICE_REST);
	private static final String CLASS_NAME = "SampleServiceHandler";
    
    public IResourceResponse onDelete(ResourceRequest request)  
    {
        throw new UnsupportedOperationException();
    }

    public IResourceResponse onPut(ResourceRequest request)  
    {
        throw new UnsupportedOperationException();
    }
    
    public IResourceResponse onGet(ResourceRequest request)  
    {
    	final String method = "onGet:" + request.getRequestId();
    	SEDLogger.entering(logger, CLASS_NAME, method);
    	try 
    	{
    	    IResourceResponse response = startRetrievingTypes(request); 
    	    return response;
    	}
    	finally 
    	{
    		SEDLogger.exiting(logger, CLASS_NAME, method);
    	}
    }
    
    public IResourceResponse onPost(ResourceRequest request) 
    {
    	final String method = "onPost:" + request.getRequestId();
    	SEDLogger.entering(logger, CLASS_NAME, method);
    	try 
    	{
    	    IResourceResponse response = startProcessingTypeProperties(request); 
    	    return response;
    	}
    	finally 
    	{
    		SEDLogger.exiting(logger, CLASS_NAME, method);
    	}
    }

    private IResourceResponse startRetrievingTypes(ResourceRequest request)
    {
    	//just return the types supported by this external data service
    	ExternalSystemConfiguration sysConfig = request.getSysConfig();
    	String pathInfo = request.getPathInfo();
    	String[] pathElements = pathInfo.split("/");
    	if (pathElements.length!=2)
    		throw ErrorStatusException.createBadRequestException(RESTConstants.ERROR_INVALID_REQUEST_URI, pathInfo);
    	if (!pathElements[1].equalsIgnoreCase(RESTConstants.TYPES_PATH_INFO))
    		throw ErrorStatusException.createBadRequestException(RESTConstants.ERROR_INVALID_REQUEST_URI, pathInfo);

    	return retrieveTypes(sysConfig);
    }
    
    private IResourceResponse retrieveTypes(ExternalSystemConfiguration sysConfig)
    {
    	try
    	{
	        Set<String> caseTypesRepresented = sysConfig.getCaseTypesRepresented();
	    	
	    	JSONArray result = new JSONArray();
	    	//get the list of case types and build the JSON payload
	    	Iterator<String> it = caseTypesRepresented.iterator();
	    	while (it.hasNext())
	    	{
	    		String type = it.next();
	    		JSONObject jsonType = new JSONObject();
	    		jsonType.put(RESTConstants.JSON_KEY_SYMBOLICNAME,type);
	    		result.add(jsonType);
	    	}
	    	return new JSONResourceResponse(result);
    	}
    	catch(JSONException e)
    	{
    		throw SEDException.createException(SEDConstants.ERROR_UNEXPECTED, e);
    	}
    }
    
    private IResourceResponse startProcessingTypeProperties(ResourceRequest request)
    {
        String testAuthenticationCEURI = request.getTestAuthenticationCEURI();
    	ExternalSystemConfiguration sysConfig = request.getSysConfig();
    	String pathInfo = request.getPathInfo();
    	String[] pathElements = pathInfo.split("/");
    	if (pathElements.length!=3)
    		throw ErrorStatusException.createBadRequestException(RESTConstants.ERROR_INVALID_REQUEST_URI, pathInfo);
    	if (!pathElements[1].equalsIgnoreCase(RESTConstants.TYPE_PATH_INFO))
    		throw ErrorStatusException.createBadRequestException(RESTConstants.ERROR_INVALID_REQUEST_URI, pathInfo);
    	
    	String requestModeParam = request.getRequiredRequestBodyParameterString(RESTConstants.JSON_KEY_REQUEST_MODE);
    	ExternalRequestMode requestMode = ExternalRequestMode.fromString(requestModeParam);
    	String externalDataIdentifier = request.getRequestBodyParameterString(RESTConstants.JSON_KEY_EXTERNAL_DATA_IDENTIFIER);
    	JSONArray propertiesParam = (JSONArray) request.getRequestBodyParameterObject(RESTConstants.JSON_KEY_PROPERTIES);
    	String objType = pathElements[2];
    	List<InputProperty> propList;
    	if (sysConfig.getCaseTypesRepresented().contains(objType))
    	    propList = PropertiesJSONConverter.processProperties(propertiesParam, sysConfig, objType);
    	else
    	    propList = new ArrayList<InputProperty>();
    	
    	return processTypeProperties(objType,requestMode,
    			propList, externalDataIdentifier, sysConfig, testAuthenticationCEURI);
    }
    
    private IResourceResponse processTypeProperties(String type, ExternalRequestMode requestMode, List<InputProperty> currentProperties,
            String currentOpaqueIdentifier, ExternalSystemConfiguration sysConfig,
            String testAuthenticationCEURI)
    {
        // If configured, try logging on to CE which requires authentication
        if (testAuthenticationCEURI != null && testAuthenticationCEURI.length() > 0)
        {
            SEDLogger.trace(logger, "To test authentication to sample service, fetching CE domain...");
            Connection conn = Factory.Connection.getConnection(testAuthenticationCEURI);
            Domain domain = Factory.Domain.fetchInstance(conn, null, null);
            SEDLogger.trace(logger, "Fetched CE domain: " + domain.get_Name());
        }
        else
        {
            SEDLogger.trace(logger, "Test authentication CE URI not configured, skipping access to CE domain.");
        }
        
    	ExternalSystemConfiguration.FetchExternalPropertiesData epdata = sysConfig.fetchExternalProperties(type, requestMode, currentProperties, currentOpaqueIdentifier);
    	  	
    	return generateJSONResponse(epdata);
    }
    
    private IResourceResponse generateJSONResponse(ExternalSystemConfiguration.FetchExternalPropertiesData data)
    {
    	try
    	{
	    	OrderedJSONObject result = new OrderedJSONObject();
	    	result.put(RESTConstants.JSON_KEY_EXTERNAL_DATA_IDENTIFIER, data.getOpaqueIdentifer());
	    	List<ExternalProperty> list = data.getExternalProperties();
	    	JSONArray jaProps = PropertiesJSONConverter.generateJSONProperties(list);
	    	result.put(RESTConstants.JSON_KEY_PROPERTIES,jaProps);
	    	
	    	return new JSONResourceResponse(result);
    	}
    	catch(JSONException e)
    	{
    		throw SEDException.createException(SEDConstants.ERROR_UNEXPECTED, e);
    	}
    }
    
    public IResourceResponse handleErrorResponse(Throwable t)
    {
        int statusCode = HttpServletResponse.SC_INTERNAL_SERVER_ERROR;
        if (t instanceof ErrorStatusException)
        {
            ErrorStatusException estatEx = (ErrorStatusException) t;
            statusCode = estatEx.getStatusCode();
        }
        
        JSONResourceResponse response = generateErrorResponse(statusCode, t);
        
        if (t instanceof ErrorStatusException)
        	processErrorStatusResponse(response, (ErrorStatusException)t);
        
        return response;
    }
    
    private JSONResourceResponse generateErrorResponse(int statusCode, Throwable t)
    {
    	try
    	{
	        JSONObject body = new JSONObject();
	        JSONObject messageContents = new JSONObject();
	        
	        messageContents.put(RESTConstants.JSON_KEY_TEXT, SEDException.getEffectiveExceptionMessage(t));
	        
	        body.put(RESTConstants.JSON_KEY_USER_MESSAGE, messageContents);
	        
	        JSONObject causes = new JSONObject();
	        JSONArray causesArray = new JSONArray();
	        Throwable cause = t.getCause();
	        while (cause != null)
	        {
	            causesArray.add(SEDException.getEffectiveExceptionMessage(cause));
	            cause = cause.getCause();
	        }
	        causes.put(RESTConstants.JSON_KEY_CAUSES, causesArray);
	        
	        body.put(RESTConstants.JSON_KEY_UNDERLYING_DETAILS, causes);
	        
	        JSONResourceResponse response = new JSONResourceResponse(body);
	        response.setStatus(statusCode);
	        
	        return response;
    	}
    	catch(JSONException e)
    	{
    		throw SEDException.createException(SEDConstants.ERROR_UNEXPECTED, e);
    	}
    }
    
    private IResourceResponse processErrorStatusResponse(IResourceResponse response, ErrorStatusException error)
    {
        if (error instanceof NotAllowedException)
        {
            NotAllowedException nae = (NotAllowedException) error;
            nae.getAllowedMethods();
            response.putHeader(HTTPHeaderConstants.ALLOW, nae.getAllowedMethods(), false);
        }
        
        return response;
    }
}