/*
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5725A15
 * 
 *  Copyright IBM Corp. 2010,2011
 * 
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 */

package com.ibm.casemgmt.sampexterndata.rest;

final class RESTConstants 
{
    public static final String LOGGER_SAMPLE_SERVICE_REST = "com.ibm.casemgmt.sampexterndata.rest";
    
    public static final String ERROR_REQUEST_BODY_NOT_VALID_JSON = "The Request Body for the REST call is not in valid JSON format.";
    public static final String ERROR_INVALID_REQUEST_BODY_TYPE = "The JSON request body parameter {0} is of the wrong type {1}.";
    public static final String ERROR_MISSING_REQUEST_PARAM = "The current REST request cannot be processed because the required {0} parameter is missing.";
    public static final String ERROR_INVALID_REQUEST_PARAM_VALUE = "The {0} request parameter has an invalid value of {1}.";
    public static final String ERROR_INVALID_REQUEST_URI = "Invalid request URI {0}";

    //path info
    public static final String TYPE_PATH_INFO = "type";
    public static final String TYPES_PATH_INFO = "types";
    
    //json keys
    public static final String JSON_KEY_REPOSITORY_ID = "repositoryId";
    public static final String JSON_KEY_OBJECT_ID = "objectId";
    public static final String JSON_KEY_REQUEST_MODE = "requestMode";
    public static final String JSON_KEY_EXTERNAL_DATA_IDENTIFIER = "externalDataIdentifier";

    // Property attributes
    public static final String JSON_KEY_SYMBOLICNAME       = "symbolicName";
    public static final String JSON_KEY_REQUIRED           = "required";
    public static final String JSON_KEY_HIDDEN             = "hidden";
    public static final String JSON_KEY_MAXVALUE           = "maxValue";
    public static final String JSON_KEY_MINVALUE           = "minValue";
    public static final String JSON_KEY_MAXLENGTH          = "maxLength";
    public static final String JSON_KEY_CHOICELIST         = "choiceList";
    public static final String JSON_KEY_DISPLAYNAME        = "displayName";
    
    public static final String JSON_KEY_CHOICES            = "choices";
    public static final String JSON_KEY_VALUE              = "value";
    public static final String JSON_KEY_DISPLAY_MODE       = "displayMode";
    public static final String JSON_KEY_CUSTOM_VALIDATION_ERROR = "customValidationError";
    public static final String JSON_KEY_CUSTOM_INVALID_ITEMS = "customInvalidItems";
    public static final String JSON_KEY_HAS_DEPENDENT_PROPERTIES   = "hasDependentProperties";
    
    public static final String JSON_KEY_PROPERTIES = "properties";
    public static final String JSON_KEY_CLIENT_CONTEXT = "clientContext";
    
    
    // JSON return values -- property attributes
    public static final String JSON_VALUE_READWRITE          = "readwrite";
    public static final String JSON_VALUE_READONLY           = "readonly";
    
    // Error response keys
    public static final String JSON_KEY_USER_MESSAGE        = "userMesssage";
    public static final String JSON_KEY_TEXT                = "text";
    public static final String JSON_KEY_UNDERLYING_DETAILS  = "underlyingDetails";
    public static final String JSON_KEY_CAUSES              = "causes";

    private RESTConstants() {}
}
