/*
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5725A15
 * 
 *  Copyright IBM Corp. 2010,2011
 * 
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 */
package com.ibm.casemgmt.sampexterndata.rest;

import com.ibm.casemgmt.sampexterndata.api.SEDException;

/**
 * Represents 405 Not Allowed error response
 */
public final class NotAllowedException extends ErrorStatusException 
{
	/**
	 * 
	 */
	private static final long serialVersionUID = -3534253990801809668L;
    private static final String EMPTY_STRING = "";
    
    private final String allowedMethods;
    
    public static NotAllowedException createNotAllowedException(String allowedMethods, String formatPattern, Object... params)
    {
        String formattedMsg = SEDException.formatErrorMessage(formatPattern, params);
        return new NotAllowedException(allowedMethods, formattedMsg);
    }
    
    public static NotAllowedException createNotAllowedException(String allowedMethods, String formatPattern, Throwable cause, Object... params)
    {
        String formattedMsg = SEDException.formatErrorMessage(formatPattern, params);
        return new NotAllowedException(allowedMethods, formattedMsg, cause);
    }
    
    private NotAllowedException(String allowedMethods, String formattedMsg)
    {
        super(HTTPHeaderConstants.SC_NOT_ALLOWED, formattedMsg);
        this.allowedMethods = effectiveAllowedMethods(allowedMethods);
    }
    
    private NotAllowedException(String allowedMethods, String formattedMsg, Throwable cause)
    {
        super(HTTPHeaderConstants.SC_NOT_ALLOWED, formattedMsg, cause);
        this.allowedMethods = effectiveAllowedMethods(allowedMethods);
    }
    
    public String getAllowedMethods()
    {
        return allowedMethods;
    }
    
    private String effectiveAllowedMethods(String allowedMethods)
    {
        String effectiveAllowedMethods;
        if (allowedMethods != null)
            effectiveAllowedMethods = allowedMethods;
        else
            effectiveAllowedMethods = EMPTY_STRING;
        return effectiveAllowedMethods;
    }
    
}
