/*
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5725A15
 * 
 *  Copyright IBM Corp. 2010,2011
 * 
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 */
package com.ibm.casemgmt.sampexterndata.rest;

import java.text.SimpleDateFormat;
import java.util.SimpleTimeZone;

import org.apache.commons.json.JSON;
import org.apache.commons.json.JSONArtifact;

public final class JSONUtils {
	private final static String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

	public static JSONArtifact getJSONFromString(String s)
	{
		try
		{
			return JSON.parse(s);
		}
		catch (Exception e)
		{
			return null;
		}
	}
	
	public static String convertDateToString(java.util.Date date)
    {
        if (date == null)
            return "";
        else
        {
            SimpleDateFormat dateFormatter = new SimpleDateFormat(DATE_FORMAT);
            dateFormatter.setTimeZone(new SimpleTimeZone(0, "UTC"));
            return dateFormatter.format(date);
        }
    }
	
	private JSONUtils(){}
	
}
