/*
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5725A15
 * 
 *  Copyright IBM Corp. 2010,2011
 * 
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 */
package com.ibm.casemgmt.sampexterndata.rest;

import java.io.BufferedOutputStream;
import java.io.IOException;

import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONArtifact;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

import com.ibm.casemgmt.sampexterndata.api.SEDConstants;
import com.ibm.casemgmt.sampexterndata.api.SEDException;

public final class JSONResourceResponse extends BaseResourceResponse {
	
	private JSONArtifact jsonObj = null;

	public JSONResourceResponse(int scCode, JSONObject jsonObj)
	{
		setStatus(scCode);
		this.jsonObj = jsonObj;
		checkStatus();
	}
	public JSONResourceResponse(JSONArtifact jsonObj)
	{
		this.jsonObj = jsonObj;
		checkStatus();
	}
	public JSONResourceResponse ()
	{
		setStatus(javax.servlet.http.HttpServletResponse.SC_NO_CONTENT); 
	}
	
	// if scCode is SC_OK, we want to just go ahead and add the content type according
	private void checkStatus()
	{
		if (getStatus()==javax.servlet.http.HttpServletResponse.SC_OK)
		{
			if (jsonObj!=null)
				putHeader(HTTPHeaderConstants.CONTENT_TYPE, HTTPHeaderConstants.VALUE_CONTENT_TYPE_JSON, false);
		}
	}
	
	@Override
	public void write(StringBuffer buf)
	{
		if (jsonObj==null)
			return;
		try
		{
			buf.append(jsonObj.write());
		}
		catch(JSONException e)
		{
			throw SEDException.createException(SEDConstants.ERROR_UNEXPECTED, e);
		}
	}
	
	@Override
	public void write(java.io.OutputStream outStream)
	{
		if (jsonObj==null)
			return;
		
		try
		{
			//temporary fix for properly return JSONArray's with new Apache JSON4J
			if (jsonObj instanceof JSONArray)
			{
				StringBuilder sb = new StringBuilder(jsonObj.write());
				BufferedOutputStream bos = new BufferedOutputStream(outStream);
				for (int i=0;i<sb.length();i++)
				{
					bos.write(sb.charAt(i));
				}
				bos.close();
				return;
			}
			jsonObj.write(outStream);
		}
		catch(IOException e)
		{
			throw SEDException.createException(SEDConstants.ERROR_UNEXPECTED, e);
		}
		catch(JSONException e)
		{
			throw SEDException.createException(SEDConstants.ERROR_UNEXPECTED, e);
		}
	}	
}
