/*
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5725A15
 * 
 *  Copyright IBM Corp. 2011
 * 
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 */
package com.ibm.casemgmt.sampexterndata.rest;

import com.filenet.api.constants.Cardinality;
import com.filenet.api.constants.TypeID;
import com.ibm.casemgmt.sampexterndata.api.InputProperty;
import com.ibm.casemgmt.sampexterndata.api.PropertyValueHolder;

final class InputPropertyImpl implements InputProperty
{
	private final String symbolicName;
	private final PropertyValueHolder pvh;
	
	public InputPropertyImpl(String symbolicName, TypeID dataType, Cardinality cardinality, boolean requiresUniqueElements)
	{
	    this.symbolicName = symbolicName;
		pvh = PropertyValueHolder.createHolder(dataType, cardinality, requiresUniqueElements);
	}
	
	public void setObjectValue(Object value)
	{
		pvh.setObjectValue(value);
	}
	
	public void unspecifyValue()
	{
		pvh.unspecifyValue();
	}
	
	public Cardinality getCardinality() {
		return pvh.getCardinality();
	}

	public TypeID getPropertyType() {
		return pvh.getDataType();
	}

	public boolean getRequiresUniqueElements() {
		return pvh.getRequiresUniqueElements();
	}

	public String getSymbolicName() {
		return symbolicName;
	}

	public Object getValue() {
		return pvh.getValue();
	}

	public boolean isValueSpecified() {
		return pvh.isValueSpecified();
	}

}

