/*
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5725A15
 * 
 *  Copyright IBM Corp. 2010,2011
 * 
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 */
package com.ibm.casemgmt.sampexterndata.rest;

import javax.servlet.http.HttpServletResponse;

import com.ibm.casemgmt.sampexterndata.api.SEDException;

public class ErrorStatusException extends SEDException 
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 4844387433881928100L;
	private final int statusCode;
    
    // 400 Bad Request 
    
    public static ErrorStatusException createBadRequestException(String formatPattern, Object... params)
    {
        String formattedMsg = SEDException.formatErrorMessage(formatPattern, params);
        return new ErrorStatusException(HttpServletResponse.SC_BAD_REQUEST, formattedMsg);
    }
    
    public static ErrorStatusException createBadRequestException(String formatPattern, Throwable cause, Object... params)
    {
        String formattedMsg = SEDException.formatErrorMessage(formatPattern, params);
        return new ErrorStatusException(HttpServletResponse.SC_BAD_REQUEST, formattedMsg, cause);
    }
    
    public static ErrorStatusException createBadRequestException(SEDException e)
    {
    	return new ErrorStatusException(HttpServletResponse.SC_BAD_REQUEST,e);
    }

    
    // 404 Not Found
    
    public static ErrorStatusException createNotFoundException(String formatPattern, Object... params)
    {
        String formattedMsg = SEDException.formatErrorMessage(formatPattern, params);
        return new ErrorStatusException(HttpServletResponse.SC_NOT_FOUND, formattedMsg);
    }
    
    public static ErrorStatusException createNotFoundException(String formatPattern, Throwable cause, Object... params)
    {
        String formattedMsg = SEDException.formatErrorMessage(formatPattern, params);
        return new ErrorStatusException(HttpServletResponse.SC_NOT_FOUND, formattedMsg, cause);
    }

    public static ErrorStatusException createNotFoundException(SEDException e)
    {
    	return new ErrorStatusException(HttpServletResponse.SC_NOT_FOUND,e);
    }

    // 501 Not Implemented
    
    public static ErrorStatusException createNotImplementedException(String formatPattern, Object... params)
    {
        String formattedMsg = SEDException.formatErrorMessage(formatPattern, params);
        return new ErrorStatusException(HttpServletResponse.SC_NOT_IMPLEMENTED, formattedMsg);
    }
    
    public static ErrorStatusException createNotImplementedException(String formatPattern, Throwable cause, Object... params)
    {
        String formattedMsg = SEDException.formatErrorMessage(formatPattern, params);
        return new ErrorStatusException(HttpServletResponse.SC_NOT_IMPLEMENTED, formattedMsg, cause);
    }
    
    protected ErrorStatusException(int statusCode, String formattedMsg)
    {
        super(formattedMsg);
        this.statusCode = statusCode;
    }
    
    protected ErrorStatusException(int statusCode, String formattedMsg, Throwable cause)
    {
        super(formattedMsg, cause);
        this.statusCode = statusCode;
    }
    
    protected ErrorStatusException(int statusCode, SEDException e)
    {
    	super(e);
    	this.statusCode = statusCode;
    	
    }
    
    public final int getStatusCode()
    {
        return statusCode;
    }

}
