/*
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5725A15
 * 
 *  Copyright IBM Corp. 2010
 * 
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 */
package com.ibm.casemgmt.sampexterndata.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class BaseResourceResponse implements IResourceResponse {
	
	private  Map<String,List<String>> responseHeaders = new HashMap<String,List<String>>(2);
	private int scCode = javax.servlet.http.HttpServletResponse.SC_OK;

	protected BaseResourceResponse ()
	{
		putHeader( "Pragma", "no-cache",false );
		putHeader( "Cache-Control", "no-cache", false );
		putHeader ( "Expires", Utils.HTTPGMTDate(new Date()), false );
	}
	public final int getStatus()
	{
		return scCode;
	}
	public final void setStatus(int scCode)
	{
		this.scCode = scCode;
	}
	public final Map<String,List<String>> getResponseHeaders()
	{
	    Map<String, List<String>> rtnHeaders = new HashMap<String, List<String>>();
	    Iterator<String> it = responseHeaders.keySet().iterator();
	    while (it.hasNext())
	    {
	        String key = it.next();
	        rtnHeaders.put(key, Collections.unmodifiableList(responseHeaders.get(key)));
	    }
		return Collections.unmodifiableMap(rtnHeaders);
	}

	
	public final void putHeader(String headerName, String headerValue, boolean append)
	{
		List<String> headerList = null;
		// for replacement..
		if (append)
			headerList = responseHeaders.get(headerName);	
		
		if (headerList==null)
		{
			headerList = new ArrayList<String>(1);
			responseHeaders.put(headerName, headerList);
		}	
		headerList.add(headerValue);		
	}
	public final List<String> getHeader(String headerName)
	{
	    List<String> rtnHeader = responseHeaders.get(headerName);
	    if (rtnHeader != null)
	        rtnHeader = Collections.unmodifiableList(rtnHeader);
		return rtnHeader;
	}
	public final String getHeaderFirstValue(String headerName)
	{
		List<String> vals = responseHeaders.get(headerName);
		if(vals!=null)
		{
			return vals.get(0);
		}
		return null;
	}
	

	public abstract void write(StringBuffer buf);
	
	public abstract void write(java.io.OutputStream outStream);

}
