/*
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5725A15
 * 
 *  Copyright IBM Corp. 2010,2011
 * 
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 */
package com.ibm.casemgmt.sampexterndata.api;

import org.apache.commons.logging.Log;

public final class SEDLogger 
{
	private static final String SEPARATOR = ":";
	private static final String COMMA = ",";
    private static String ENTERING_PREFIX = "Entering ";
    private static final String EXITING_PREFIX = "Exiting "; 
	
	public static void info(Log theLog, String ... messages)
	{
		if (theLog.isInfoEnabled())
		{
		    String completeMessage = appendMessages(messages);
			theLog.info(completeMessage);
		}
	}
	
	/**
	 * Appends several message together delimited by commas
	 * @param messages
	 * @return
	 */
	private static String appendMessages(String ... messages)
	{
	    String completeMessage;
	    if (messages.length == 1)
	    {
	        completeMessage = messages[0];
	    }
	    else
	    {
            StringBuffer sb = new StringBuffer();
            boolean firstMessage = true;
            for (String s : messages)
            {
                if (!firstMessage)
                    sb.append(COMMA);
                firstMessage = false;
                sb.append(s);
            }
            completeMessage = sb.toString();
	    }
	    return completeMessage;
	}
	
	public static void warn(Log theLog, String ... messages)
	{
	    if (theLog.isWarnEnabled())
	    {
            String completeMessage = appendMessages(messages);
            theLog.warn(completeMessage);
	    }
	}
	
	public static void warn(Log theLog, String message, Throwable t)
	{
        if (theLog.isWarnEnabled())
        {
            theLog.warn(message, t);
        }
	}

	public static void error(Log theLog, String ... messages )
	{
		if (theLog.isErrorEnabled())
		{
            String completeMessage = appendMessages(messages);
			theLog.error(completeMessage);
		}
	}
	
	public static void error(Log theLog, String message, Throwable t)
	{
	    if (theLog.isErrorEnabled())
	    {
	        theLog.error(message, t);
	    }
	}
	
	/**
	 * This logs a trace message when the code is about to throw an exception.
	 * The exception will typically be caught by higher level code and logged
	 * as an error but logging a trace message at the point when the exception
	 * is thrown is a way to ensure that important information doesn't get lost 
	 * if the higher level code doesn't log the error for some reason.  Tracing
	 * can always be enabled to capture more information if the expected detail
	 * isn't in the normal log.
	 */
	public static void throwing(Log theLog, String msg, Throwable t)
	{
		if (theLog.isTraceEnabled())
		{
			theLog.trace( msg, t);
		}
	}

	
	public static void trace(Log theLog, String ... messages )
	{
		if (theLog.isTraceEnabled())
		{
            String completeMessage = appendMessages(messages);
			theLog.trace(completeMessage);
		}
	}

	public static void entering(Log theLog, String className, String methodName)
	{
		if (theLog.isTraceEnabled())
		{
			theLog.trace(ENTERING_PREFIX + className + SEPARATOR + methodName);
		}
	}
	
	public static void exiting(Log theLog, String className, String methodName)
	{
		if (theLog.isTraceEnabled())
		{
			theLog.trace(EXITING_PREFIX + className + SEPARATOR + methodName);
		}
	}
	
}
