/*
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5725A15
 * 
 *  Copyright IBM Corp. 2010,2011
 * 
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 */
package com.ibm.casemgmt.sampexterndata.api;

import java.text.MessageFormat;

public class SEDException extends RuntimeException
{
    /**
	 * 
	 */
	private static final long serialVersionUID = 3866292387460571018L;

    public static SEDException createException(String formatPattern, Object... params)
    {
        String formattedMsg = formatErrorMessage(formatPattern, params);
        return new SEDException(formattedMsg);
    }

    public static SEDException createException(String formatPattern, Throwable cause, Object... params)
    {
        String formattedMsg = formatErrorMessage(formatPattern, params);
        return new SEDException(formattedMsg, cause);
    }

    /**
     * Helper method to generate an appropriate error message from an exception.
     * It will either be the message from the exception itself or, if the exception
     * has no message, something of the form "Unspecified error of type: NullPointerException"
     */
    public static String getEffectiveExceptionMessage(Throwable t)
    {
        String message = t.getLocalizedMessage();
        if (message == null || message.length() == 0)
        {
            String typ = t.getClass().getSimpleName();
            message = formatErrorMessage(SEDConstants.ERROR_UNSPECIFIED_EXCEPTION, typ);
        }
        return message;
    }
    
    static public String formatErrorMessage(String formatPattern, Object... arguments)
    {
        String msg;
        MessageFormat msgFormat = new MessageFormat(formatPattern);
        try
        {
            StringBuffer buffer = new StringBuffer(formatPattern.length());
            msgFormat.format(arguments, buffer, null);
            msg = buffer.toString();
        }
        catch(IllegalArgumentException iae)
        {
            // Invalid arguments, do the fallback
            msg = null;
        }
        // Use format pattern if any problems
        if (msg == null)
            msg = formatPattern;
        return msg;
    }

    protected SEDException(String formattedMsg)
    {
        super(formattedMsg);
    }

    protected SEDException(String formattedMsg, Throwable cause)
    {
        super(formattedMsg, cause);
    }

    /**
     * This constructor is used to convert a SEDException or sub-class instance
     * to another sub-class.
     */
    protected SEDException(SEDException e)
    {
   		super(e.getLocalizedMessage(),e.getCause());
    }
	
}

