/*
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5725A15
 * 
 *  Copyright IBM Corp. 2010,2011
 * 
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 */
package com.ibm.casemgmt.sampexterndata.api;

public enum ExternalRequestMode 
{
    INITIAL_NEW_OBJECT,
    INITIAL_EXISTING_OBJECT,
    IN_PROGRESS_CHANGES,
    FINAL_NEW_OBJECT,
    FINAL_EXISTING_OBJECT;
    
    public static final String VALUE_INITIAL_NEW_OBJECT = "initialNewObject";
    public static final String VALUE_INITIAL_EXISTING_OBJECT = "initialExistingObject";
    public static final String VALUE_FINAL_NEW_OBJECT = "finalNewObject";
    public static final String VALUE_FINAL_EXISTING_OBJECT = "finalExistingObject";
    public static final String VALUE_IN_PROGRESS_CHANGES = "inProgressChanges";
    
    public static ExternalRequestMode fromString(String value)
    {
    	ExternalRequestMode requestMode;
    	if (value.equalsIgnoreCase(VALUE_INITIAL_EXISTING_OBJECT))
    		requestMode = ExternalRequestMode.INITIAL_EXISTING_OBJECT;
    	else if (value.equalsIgnoreCase(VALUE_IN_PROGRESS_CHANGES))
    		requestMode = ExternalRequestMode.IN_PROGRESS_CHANGES;
    	else if (value.equalsIgnoreCase(VALUE_INITIAL_NEW_OBJECT))
    		requestMode = ExternalRequestMode.INITIAL_NEW_OBJECT;
    	else if (value.equalsIgnoreCase(VALUE_FINAL_EXISTING_OBJECT))
    		requestMode = ExternalRequestMode.FINAL_EXISTING_OBJECT;
    	else if (value.equalsIgnoreCase(VALUE_FINAL_NEW_OBJECT))
    		requestMode = ExternalRequestMode.FINAL_NEW_OBJECT;
    	else
    		throw new IllegalArgumentException();
    	
    	return requestMode;
    }
    
    public static String toString(ExternalRequestMode mode)
    {
    	String requestMode;
    	if (mode == ExternalRequestMode.INITIAL_EXISTING_OBJECT)
    		requestMode = VALUE_INITIAL_EXISTING_OBJECT;
    	else if (mode == ExternalRequestMode.IN_PROGRESS_CHANGES)
    		requestMode = VALUE_IN_PROGRESS_CHANGES;
    	else if (mode == ExternalRequestMode.INITIAL_NEW_OBJECT)
    		requestMode = VALUE_INITIAL_NEW_OBJECT;
    	else if (mode == ExternalRequestMode.FINAL_EXISTING_OBJECT)
    		requestMode = VALUE_FINAL_EXISTING_OBJECT;
    	else if (mode == ExternalRequestMode.FINAL_NEW_OBJECT)
    		requestMode = VALUE_FINAL_NEW_OBJECT;
    	else
    		throw new IllegalArgumentException();
    	
    	return requestMode;
    	
    }
}
