/*
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5725A15
 * 
 *  Copyright IBM Corp. 2010,2011
 * 
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 */
package com.ibm.casemgmt.sampexterndata.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import com.filenet.api.constants.ChoiceType;
import com.filenet.api.constants.TypeID;

public final class ExternalChoiceList 
{
    private final String displayName;
    private final TypeID dataType;
    private final List<ExternalChoice> choices = new ArrayList<ExternalChoice>();
    
    static ExternalChoiceList createChoiceList(String displayName, TypeID dataType, List<ExternalChoice> choices)
    {
        if (dataType != TypeID.LONG && dataType != TypeID.STRING)
            throw SEDException.createException(SEDConstants.ERROR_UNEXPECTED);
        validateChoicesList(dataType, choices);
        return new ExternalChoiceList(displayName, dataType, choices);
    }
    
    static private void validateChoicesList(TypeID dataType, List<ExternalChoice> choices)
    {
        Iterator<ExternalChoice> it = choices.iterator();
        while (it.hasNext())
        {
            ExternalChoice c = it.next();
            if (    (dataType == TypeID.LONG 
                        && c.getChoiceType() != ChoiceType.INTEGER 
                        && c.getChoiceType() != ChoiceType.MIDNODE_INTEGER)
                    ||
                    (dataType == TypeID.STRING 
                            && c.getChoiceType() != ChoiceType.STRING 
                            && c.getChoiceType() != ChoiceType.MIDNODE_STRING))
            {
                throw SEDException.createException(SEDConstants.ERROR_UNEXPECTED);
            }
        }
    }
    
    private ExternalChoiceList(String displayName, TypeID dataType, List<ExternalChoice> choices)
    {
        this.displayName = displayName;
        this.dataType = dataType;
        this.choices.addAll(choices);
    }
    
    public String getDisplayName()
    {
        return displayName;
    }
    
    public TypeID getDataType()
    {
        return dataType;
    }
    
    public boolean hasHierarchy()
    {
        Iterator<ExternalChoice> it = choices.iterator();
        boolean has = false;
        while (it.hasNext())
        {
            ExternalChoice c = it.next();
            if (c.getChoiceType() == ChoiceType.MIDNODE_INTEGER || c.getChoiceType() == ChoiceType.MIDNODE_STRING)
            {
                has = true;
                break;
            }
        }
        return has;
    }

    /**
     * Returns read-only list of choices
     */
    public List<ExternalChoice> getChoices()
    {
        return Collections.unmodifiableList(choices);
    }
    
    /**
     * Verify a value is valid for this choice list.  The value can be either a single
     * Integer or String or a list of Integers or Strings
     */
    boolean isValueValid(Object value)
    {
        boolean valid;
        if (value instanceof List<?>)
        {
            valid = true;
            List<?> list = (List<?>) value;
            for (int i = 0; i < list.size(); i++)
            {
                Object itemVal = list.get(i);
                if (!isValueInChoices(itemVal))
                {
                    valid = false;
                    break;
                }
            }
        }
        else
            valid = isValueInChoices(value);
        return valid;
    }
    
    private boolean isValueInChoices(Object value)
    {
        boolean inChoices = false;
        Iterator<ExternalChoice> choicesIt = choices.iterator();
        while (choicesIt.hasNext())
        {
            ExternalChoice choice = choicesIt.next();
            if (choice.isValueValid(value))
            {
                inChoices = true;
                break;
            }
        }
        return inChoices;
    }
}
