/*
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5725A15
 * 
 *  Copyright IBM Corp. 2010,2011
 * 
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 */
package com.ibm.casemgmt.sampexterndata.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import com.filenet.api.constants.ChoiceType;

public final class ExternalChoice 
{
    private final String displayName;
    private final ChoiceType choiceType;
    private final String singleString;
    private final Integer singleInteger;
    private final List<ExternalChoice> groupOfChoices;
    
    static ExternalChoice createSingleIntegerChoice(String displayName, Integer value)
    {
        return new ExternalChoice(displayName, value);
    }
    
    static ExternalChoice createSingleStringChoice(String displayName, String value)
    {
        return new ExternalChoice(displayName, value);
    }
    
    static ExternalChoice createGroupChoice(String displayName, ChoiceType groupChoiceType, List<ExternalChoice> groupOfChoices)
    {
        if (groupChoiceType != ChoiceType.MIDNODE_INTEGER && groupChoiceType != ChoiceType.MIDNODE_STRING)
            throw SEDException.createException(SEDConstants.ERROR_UNEXPECTED);
        validateGroupOfChoices(groupChoiceType, groupOfChoices);
        List<ExternalChoice> copyGroupOfChoices = new ArrayList<ExternalChoice>();
        copyGroupOfChoices.addAll(groupOfChoices);
        return new ExternalChoice(displayName, groupChoiceType, copyGroupOfChoices);
    }
    
    private static void validateGroupOfChoices(ChoiceType groupChoiceType, List<ExternalChoice> groupOfChoices)
    {
        Iterator<ExternalChoice> it = groupOfChoices.iterator();
        while (it.hasNext())
        {
            ExternalChoice c = it.next();
            if ( (groupChoiceType == ChoiceType.MIDNODE_INTEGER 
                        && c.getChoiceType() != ChoiceType.MIDNODE_INTEGER 
                        && c.getChoiceType() != ChoiceType.INTEGER)
                 ||
                 (groupChoiceType == ChoiceType.MIDNODE_STRING 
                        && c.getChoiceType() != ChoiceType.MIDNODE_STRING 
                        && c.getChoiceType() != ChoiceType.STRING))
            {
                throw SEDException.createException(SEDConstants.ERROR_UNEXPECTED);
            }
        }
    }
    
    /**
     * 
     */
    private ExternalChoice(String displayName, String value)
    {
        this.displayName = displayName;
        choiceType = ChoiceType.STRING;
        singleInteger = null;
        singleString = value;
        groupOfChoices = null;
    }
    
    private ExternalChoice(String displayName, Integer value)
    {
        this.displayName = displayName;
        choiceType = ChoiceType.INTEGER;
        singleInteger = value;
        singleString = null;
        groupOfChoices = null;
    }
    
    private ExternalChoice(String displayName, ChoiceType groupChoiceType, List<ExternalChoice> groupOfChoices)
    {
        this.displayName = displayName;
        choiceType = groupChoiceType;
        singleInteger = null;
        singleString = null;
        this.groupOfChoices = groupOfChoices;
    }
    
    public String getDisplayName()
    {
        return displayName;
    }
    
    public ChoiceType getChoiceType()
    {
        return choiceType;
    }
    
    public String getStringChoice()
    {
        return singleString;
    }
    
    public Integer getIntegerChoice()
    {
        return singleInteger;
    }
    
    public List<ExternalChoice> getGroupOfChoices()
    {
        if (groupOfChoices != null)
            return Collections.unmodifiableList(groupOfChoices);
        else
            return null;
    }
    
    boolean isValueValid(Object value)
    {
        boolean valid = false;
        if (groupOfChoices != null)
        {
            Iterator<ExternalChoice> choicesIt = groupOfChoices.iterator();
            while (choicesIt.hasNext())
            {
                ExternalChoice choice = choicesIt.next();
                if (choice.isValueValid(value))
                {
                    valid = true;
                    break;
                }
            }
        }
        else
        {
            if (value instanceof Integer)
            {
                Integer intValue = (Integer) value;
                valid = (singleInteger.equals(intValue));
            }
            else if (value instanceof String)
            {
                String strValue = (String) value;
                valid = (singleString.equals(strValue));
            }
            else
                throw SEDException.createException(SEDConstants.ERROR_UNEXPECTED);
        }
        return valid;
    }
}
