/*
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5725A15
 * 
 *  Copyright IBM Corp. 2010,2011
 * 
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 */
package com.ibm.casemgmt.sampexterndata.api;

final class ExternalCaseTypeConfiguration 
{
    private final String caseTypeName;
    private final PropertySet propertySet;
    
    ExternalCaseTypeConfiguration(String caseTypeName, PropertySet propertySet)
    {
        if (caseTypeName == null || caseTypeName.length() == 0 || propertySet == null)
            throw new IllegalArgumentException();
        this.caseTypeName = caseTypeName;
        this.propertySet = propertySet;
    }
    
    String getCaseTypeName()
    {
        return caseTypeName;
    }
    
    PropertySet getPropertySet()
    {
        return propertySet;
    }
}
