/*
 * IBM Confidential
 * 
 * OCO Source Materials
 * 
 * 5725A15
 * 
 *  Copyright IBM Corp. 2010,2011
 * 
 * The source code for this program is not published or otherwise
 * divested of its trade secrets, irrespective of what has
 * been deposited with the U.S. Copyright Office.
 */
package com.ibm.casemgmt.sampexterndata.api;

import com.ibm.casemgmt.sampexterndata.api.PropertyValueHolder;

final class ConditionalCriteria 
{
    private final CriteriaOperator operator;
    private final PropertyValueHolder value1Holder;
    private final PropertyValueHolder value2Holder;
    
    private enum CriteriaOperator
    {
        EQUALS,
        BETWEEN,
        INCLUDES
    }

    static ConditionalCriteria createEqualsCriteria(PropertyValueHolder valHolder)
    {
        return new ConditionalCriteria(CriteriaOperator.EQUALS, valHolder, null);
    }
    
    static ConditionalCriteria createBetweenCriteria(
            PropertyValueHolder lowerValHolder, 
            PropertyValueHolder upperValHolder)
    {
        return new ConditionalCriteria(CriteriaOperator.BETWEEN, lowerValHolder, upperValHolder);
    }
    
    static ConditionalCriteria createIncludesCriteria(PropertyValueHolder valHolder)
    {
        return new ConditionalCriteria(CriteriaOperator.INCLUDES, valHolder, null);
    }
    
    private ConditionalCriteria(
            CriteriaOperator operator,
            PropertyValueHolder value1Holder,
            PropertyValueHolder value2Holder)
    {
        this.operator = operator;
        this.value1Holder = value1Holder;
        this.value2Holder = value2Holder;
    }
    
    boolean matchesCriteria(PropertyValueHolder valueHolder)
    {
        boolean matches;
        switch(operator)
        {
        case EQUALS:
            matches = valueHolder.equals(value1Holder);
            break;
        case BETWEEN:
            matches = valueHolder.between(value1Holder, value2Holder);
            break;
        case INCLUDES:
            matches = valueHolder.includes(value1Holder);
            break;
        default:
            // Shouldn't happen
            throw SEDException.createException(SEDConstants.ERROR_UNEXPECTED);
        }
        return matches;
    }
}
