/*
    IBM grants you a nonexclusive copyright license to use all programming code 
	examples from which you can generate similar function tailored to your own 
	specific needs.

	All sample code is provided by IBM for illustrative purposes only.
	These examples have not been thoroughly tested under all conditions.  IBM, 
	therefore cannot guarantee or imply reliability, serviceability, or function of 
	these programs.

	All Programs or code component contained herein are provided to you AS IS  
	without any warranties of any kind.
	The implied warranties of non-infringement, merchantability and fitness for a 
	particular purpose are expressly disclaimed.

	 Copyright IBM Corporation 2008, ALL RIGHTS RESERVED.
 */

using System;
using System.Collections.Generic;
using System.Windows.Forms;

namespace SampDitaTool
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main(String[] args)
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);

            String configFilename = null;

            // load the command line arguments
            int i;
            for (i = 0; i < args.Length; i++)
            {
                // check for arguments.
                if (args[i].ToUpper().Equals("-H"))
                {
                    // -H = HELP
                    System.Console.Out.WriteLine("SampDITATool [-h -u -d -f <filename>]");
                    System.Console.Out.WriteLine(" If given no -u or -d option a gui will be shown.");
                    System.Console.Out.WriteLine(" -h                Help");
                    System.Console.Out.WriteLine(" -f <filename>     Configuration xml file");
                    System.Console.Out.WriteLine("                   This file is generated by the gui if it doesn't exist");
                    return;
                }
                else if (args[i].ToUpper().Equals("-F"))
                {
                    // -F specify a config file name
                    // the next entry is the config file name
                    if (args.Length > i + 1)
                    {
                        configFilename = args[i + 1];
                        i++;
                    }
                    else
                    {
                        // error, no second argument given
                        System.Console.Out.WriteLine("Error in command line argument -f");
                        System.Console.Out.WriteLine(" -f requires a second argument identifying");
                        System.Console.Out.WriteLine("    the xml configuration file to use.");
                        System.Console.Out.WriteLine("    This file is automatically generated when running with");
                        System.Console.Out.WriteLine("    the standard gui and upload with simulate turned on.");
                        return;
                    }
                }
            }
			
            // load the preferences
            DitaToolForm.loadProperties(configFilename);

            Application.Run(new MainForm());

            DitaToolForm.saveProperties();
        }
    }
}