/*
    IBM grants you a nonexclusive copyright license to use all programming code 
	examples from which you can generate similar function tailored to your own 
	specific needs.

	All sample code is provided by IBM for illustrative purposes only.
	These examples have not been thoroughly tested under all conditions.  IBM, 
	therefore cannot guarantee or imply reliability, serviceability, or function of 
	these programs.

	All Programs or code component contained herein are provided to you AS IS  
	without any warranties of any kind.
	The implied warranties of non-infringement, merchantability and fitness for a 
	particular purpose are expressly disclaimed.

	 Copyright IBM Corporation 2008, ALL RIGHTS RESERVED.
 */

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using FileNet.Api.Exception;

namespace SampDitaTool
{
    //
    // Form with UI components to collect necessary information
    // to connect to CE and establish security credentials for
    // the user. Once security credentials are established, the form
    // allows the user to open BulkLoader Form.
    //
    public partial class MainForm : Form
    {
        private CEConnection ce;

        //
        // Constructor
        //
        public MainForm()
        {
            ce = new CEConnection();
            InitializeComponent();
            SetInputs();
        }

        private void SetInputs()
        {
            uriTextBox.Text = DitaToolForm.stURI;
            userTextBox.Text = DitaToolForm.stUsername;
            passTextBox.Text = DitaToolForm.stPassword;
            savepassCheckBox.Checked = DitaToolForm.savePass;
        }

        private void ExtractInput()
        {
            DitaToolForm.stURI = uriTextBox.Text;
            DitaToolForm.stUsername = userTextBox.Text;
            DitaToolForm.stPassword = passTextBox.Text;
            DitaToolForm.savePass = savepassCheckBox.Checked;
        }

        //
        // Handles the event generated when 'Test Connection' button is clicked.
        // It establishes the security credentials for the user with the CE.
        //
        private void connectionButton_Click(object sender, EventArgs e)
        {
            try
            {
                ExtractInput();
                if (CheckRequiredFields())
                {
                    ce.EstablishCredentials(DitaToolForm.stUsername, DitaToolForm.stPassword, DitaToolForm.stURI);
                    statusLabel.Text = "Connection verified with Conent Engine";
                    connectionButton.Enabled = false;
                    loaderButton.Enabled = true;

                    DitaToolForm.fillProperties();
                }
            }
            catch (EngineRuntimeException ere)
            {
                if (ere.InnerException!=null)
                    statusLabel.Text = ere.InnerException.Message;
                else
                    statusLabel.Text = ere.Message;
                System.Console.WriteLine(ere.StackTrace);
            }
        }

        //
        // Handles the event generated when 'Close' button is clicked.
        // Closes this Form.
        //
        private void closeButton_Click(object sender, EventArgs e)
        {
            base.Dispose();
        }

        //
        // Checks whether all required fields are filled before 
        // performing any action.
        //
        private bool CheckRequiredFields()
        {
            bool check = true;
            if (DitaToolForm.stURI.Equals(""))
            {
                uriTextBox.Text = "Enter CE URI.";
                check = false;
            }
            if (DitaToolForm.stUsername.Equals(""))
            {
                userTextBox.Text = "Enter Username.";
                check = false;
            }
            if (DitaToolForm.stPassword.Equals(""))
            {
                passTextBox.Text = "Enter Password.";
                check = false;
            }
            return check;
        }


        //
        // Handles the event generated when 'loaderButton' is clicked.
        // Opens up BulkLoaderForm.
        //
        private void browserButton_Click(object sender, EventArgs e)
        {
            DitaToolForm form = new DitaToolForm(ce);
            form.Show();
        }
    }
}