/**
	IBM grants you a nonexclusive copyright license to use all programming code 
	examples from which you can generate similar function tailored to your own 
	specific needs.

	All sample code is provided by IBM for illustrative purposes only.
	These examples have not been thoroughly tested under all conditions.  IBM, 
	therefore cannot guarantee or imply reliability, serviceability, or function of 
	these programs.

	All Programs or code component contained herein are provided to you AS IS  
	without any warranties of any kind.
	The implied warranties of non-infringement, merchantability and fitness for a 
	particular purpose are expressly disclaimed.

	 Copyright IBM Corporation 2008, ALL RIGHTS RESERVED.
 */

package sampdita;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;

/**
 * This is the main UI class.
 */
public class MainFrame extends JFrame
{
	private SampDITATool sdt;
	DITAToolFrame dtf = null;

	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private JPanel buttonPanel = null;
	private JPanel paramPanel = null;
	private JButton loaderButton = null;
	private JButton closeButton = null;
	private JLabel uriLabel = null;
	private JTextField uriTextField = null;
	private JLabel stanzaLabel = null;
	private JTextField stanzaTextField = null;
	private JLabel userLabel = null;
	private JTextField userTextField = null;
	private JLabel passLabel = null;
	private JTextField passTextField = null;
	private JCheckBox savePassCheckBox = null;
	private CEConnection ce = null;
	private JButton connectButton = null;
	private JLabel statusLabel = null;
	
	/**
	 * This is the default constructor.
	 */
	public MainFrame(SampDITATool sdtInit, CEConnection c)
	{
		super();
		sdt = sdtInit;
		ce = c;
		initialize();
	}

	/**
	 * This method initializes this class.
	 * 
	 * @return void
	 */
	private void initialize()
	{
		this.setSize(483, 272);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.setContentPane(getJContentPane());
		this.setTitle("Content Engine Samp DITA Tool");
		this.setLocationRelativeTo(null);
		this.setFields();
	}

	/**
	 * Set the default values of all the fields
	 */
	private void setFields()
	{
		uriTextField.setText(SampDITATool.URI);
		stanzaTextField.setText(SampDITATool.JAAS_WS_STANZA);
		userTextField.setText(SampDITATool.USER_NAME);
		passTextField.setText(SampDITATool.PASSWORD);	
		savePassCheckBox.setSelected(SampDITATool.SavePassword);
	}	
	
	/**
	 * Extract the values of all the fields
	 */
	private void extractFields()
	{
		SampDITATool.URI = uriTextField.getText();
		SampDITATool.JAAS_WS_STANZA = stanzaTextField.getText();
		SampDITATool.USER_NAME = userTextField.getText();
		SampDITATool.PASSWORD = passTextField.getText();	
		SampDITATool.SavePassword = savePassCheckBox.isSelected();
	}
	/**
	 * This method initializes jContentPane.
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane()
	{
		if (jContentPane == null)
		{
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(getButtonPanel(), BorderLayout.SOUTH);
			jContentPane.add(getParamPanel(), BorderLayout.CENTER);
		}
		return jContentPane;
	}
	
	/**
	 * This method initializes buttonPanel.	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getButtonPanel()
	{
		if (buttonPanel == null)
		{
			buttonPanel = new JPanel();
			buttonPanel.setLayout(new FlowLayout());
			buttonPanel.add(getConnectButton(), null);
			buttonPanel.add(getLoaderButton(), null);
			buttonPanel.add(getCloseButton(), null);
		}
		return buttonPanel;
	}

	/**
	 * This method initializes paramPanel.	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getParamPanel()
	{
		if (paramPanel == null)
		{
			GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
			gridBagConstraints11.gridx = 1;
			gridBagConstraints11.anchor = GridBagConstraints.WEST;
			gridBagConstraints11.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints11.ipadx = 20;
			gridBagConstraints11.ipady = 20;
			gridBagConstraints11.gridwidth = 1;
			gridBagConstraints11.gridy = 4;
			statusLabel = new JLabel();
			statusLabel.setText("Click \"Test Connection\" to verify connection with CE");
			GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
			gridBagConstraints7.fill = GridBagConstraints.BOTH;
			gridBagConstraints7.gridy = 3;
			gridBagConstraints7.weightx = 1.0;
			gridBagConstraints7.ipadx = 10;
			gridBagConstraints7.ipady = 10;
			gridBagConstraints7.gridx = 1;
			GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
			gridBagConstraints6.gridx = 0;
			gridBagConstraints6.anchor = GridBagConstraints.WEST;
			gridBagConstraints6.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints6.ipadx = 10;
			gridBagConstraints6.ipady = 10;
			gridBagConstraints6.gridy = 3;
			passLabel = new JLabel();
			passLabel.setText("Password");			
			GridBagConstraints gridBagConstraints6b = new GridBagConstraints();
			gridBagConstraints6b.gridx = 2;
			gridBagConstraints6b.anchor = GridBagConstraints.WEST;
			gridBagConstraints6b.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints6b.ipadx = 10;
			gridBagConstraints6b.ipady = 10;
			gridBagConstraints6b.gridy = 3;
			savePassCheckBox = new JCheckBox("Save");
			savePassCheckBox.setText("Save");
			GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
			gridBagConstraints5.fill = GridBagConstraints.BOTH;
			gridBagConstraints5.gridy = 2;
			gridBagConstraints5.weightx = 1.0;
			gridBagConstraints5.ipadx = 10;
			gridBagConstraints5.ipady = 10;
			gridBagConstraints5.gridx = 1;
			GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
			gridBagConstraints4.gridx = 0;
			gridBagConstraints4.anchor = GridBagConstraints.WEST;
			gridBagConstraints4.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints4.ipadx = 10;
			gridBagConstraints4.ipady = 10;
			gridBagConstraints4.gridy = 2;
			userLabel = new JLabel();
			userLabel.setText("UserName");
			GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
			gridBagConstraints3.fill = GridBagConstraints.BOTH;
			gridBagConstraints3.gridy = 1;
			gridBagConstraints3.weightx = 1.0;
			gridBagConstraints3.ipadx = 10;
			gridBagConstraints3.ipady = 10;
			gridBagConstraints3.gridx = 1;
			GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
			gridBagConstraints2.gridx = 0;
			gridBagConstraints2.anchor = GridBagConstraints.WEST;
			gridBagConstraints2.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints2.ipadx = 10;
			gridBagConstraints2.ipady = 10;
			gridBagConstraints2.gridy = 1;
			stanzaLabel = new JLabel();
			stanzaLabel.setText("JAAS Stanza");
			GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
			gridBagConstraints1.fill = GridBagConstraints.BOTH;
			gridBagConstraints1.gridy = 0;
			gridBagConstraints1.weightx = 1.0;
			gridBagConstraints1.ipadx = 10;
			gridBagConstraints1.ipady = 10;
			gridBagConstraints1.gridx = 1;
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.gridx = 0;
			gridBagConstraints.anchor = GridBagConstraints.WEST;
			gridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
			gridBagConstraints.ipadx = 10;
			gridBagConstraints.ipady = 10;
			gridBagConstraints.gridy = 0;
			uriLabel = new JLabel();
			uriLabel.setText("CE URI");
			paramPanel = new JPanel();
			paramPanel.setLayout(new GridBagLayout());
			paramPanel.setBorder(BorderFactory.createTitledBorder(null, "Connection Parameters", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new Font("Dialog", Font.BOLD, 12), Color.black));
			paramPanel.add(uriLabel, gridBagConstraints);
			paramPanel.add(getUriTextField(), gridBagConstraints1);
			paramPanel.add(stanzaLabel, gridBagConstraints2);
			paramPanel.add(getStanzaTextField(), gridBagConstraints3);
			paramPanel.add(userLabel, gridBagConstraints4);
			paramPanel.add(getUserTextField(), gridBagConstraints5);
			paramPanel.add(passLabel, gridBagConstraints6);
			paramPanel.add(savePassCheckBox, gridBagConstraints6b);
			paramPanel.add(getPassTextField(), gridBagConstraints7);
			paramPanel.add(statusLabel, gridBagConstraints11);
		}
		return paramPanel;
	}

	/**
	 * This method initializes uriTextField.	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getUriTextField()
	{
		if (uriTextField == null)
		{
			uriTextField = new JTextField();
			uriTextField.setText("");
		}
		return uriTextField;
	}

	/**
	 * This method initializes stanzaTextField.	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getStanzaTextField()
	{
		if (stanzaTextField == null)
		{
			stanzaTextField = new JTextField();
			stanzaTextField.setText("");
		}
		return stanzaTextField;
	}

	/**
	 * This method initializes userTextField.	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getUserTextField()
	{
		if (userTextField == null)
		{
			userTextField = new JTextField();
			userTextField.setText("");
		}
		return userTextField;
	}

	/**
	 * This method initializes passTextField.	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getPassTextField()
	{
		if (passTextField == null)
		{
			passTextField = new JTextField();
			passTextField.setText("");
		}
		return passTextField;
	}
	
	/**
	 * This method initializes connectButton.	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getConnectButton()
	{
		if (connectButton == null)
		{
			connectButton = new JButton();
			connectButton.setText("Test Connection");
			connectButton.setName("connectButton");
			connectButton.addActionListener(new java.awt.event.ActionListener()
				{
					public void actionPerformed(java.awt.event.ActionEvent e)
					{
						connectButtonActionPerformed(e);
					}
				});
		}
		return connectButton;
	}
	
	/**
	 * This method initializes loaderButton.	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getLoaderButton()
	{
		if (loaderButton == null)
		{
			loaderButton = new JButton();
			loaderButton.setText("Open Dita Tool");
			loaderButton.setEnabled(false);
			loaderButton.addActionListener(new java.awt.event.ActionListener()
				{
					public void actionPerformed(java.awt.event.ActionEvent e)
					{
						loaderButtonActionPerformed(e);
					}
				});
		}
		return loaderButton;
	}
	
	/**
	 * This method initializes closeButton.	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getCloseButton()
	{
		if (closeButton == null)
		{
			closeButton = new JButton();
			closeButton.setText("Close");
			closeButton.addActionListener(new java.awt.event.ActionListener()
				{
					public void actionPerformed(java.awt.event.ActionEvent e)
					{
						closeButtonActionPerformed(e);
					}
				});
		}
		return closeButton;
	}
	
	/*
	 * Action performed on clicking Close button.
	 * It closes this JFrame.
	 */
	private void closeButtonActionPerformed(java.awt.event.ActionEvent e)
	{
		MainFrame.this.dispose();
	}
	
    /*
     * Action performed on clicking Connect button.
     * It does the JAAS login.
     */
	private void connectButtonActionPerformed(java.awt.event.ActionEvent evt)
    {
        try
        {
            String uri = uriTextField.getText();
            String stanza = stanzaTextField.getText();
            String user = userTextField.getText();
            String pass = passTextField.getText();
            if(checkRequireFields()== true)
            {
            	ce.establishConnection(user,pass,stanza,uri);
            	connectButton.setEnabled(false);
            	loaderButton.setEnabled(true);
            	statusLabel.setText("Connection to CE successful");
            	extractFields();
            	SampDITATool.saveProperties();
            }
        }
        catch (EngineRuntimeException e)
        {
        	if(e.getExceptionCode() == ExceptionCode.E_NOT_AUTHENTICATED)
        	{
        		statusLabel.setText("Invalid login credentials supplied - please try again");
        	}
        	else if(e.getExceptionCode() == ExceptionCode.API_UNABLE_TO_USE_CONNECTION)
        	{
        		statusLabel.setText("Unable to connect to server.  Please check to see that URL is correct and server is running");
        	}
        	else
        	{
        		statusLabel.setText(e.getMessage());
        	}
            e.printStackTrace();
        }
    }
	
	/*
	 * Action performed on clicking Loader button.
	 * It opens up LoaderFrame from which user can
	 * load documents in object store.
	 */
	private void loaderButtonActionPerformed(java.awt.event.ActionEvent e)
	{
		SwingUtilities.invokeLater(new Runnable()
		{
			public void run()
			{
				if ((dtf==null) || (!dtf.isVisible()))
				{
					dtf = new DITAToolFrame(sdt,ce);
					dtf.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
					dtf.setVisible(true);
					dtf.setLocationRelativeTo(null);
				}
				else
				{
					dtf.toFront();
				}
			}
		});
	}
    
    /*
     * Checks whether all required fields are filled before 
     * performing any action.
     */
    private boolean checkRequireFields()
    {
    	boolean con = true;
    	if(uriTextField.getText().equals(""))
    	{
    		statusLabel.setText("URI field can not be empty");
    		con = false;
    	}
    	else if(stanzaTextField.getText().equals(""))
    	{
    		statusLabel.setText("JAAS Stanza field can not be empty");
    		con = false;
    	}
    	else if(userTextField.getText().equals(""))
    	{
    		statusLabel.setText("UserName field can not be empty");
    		con = false;
    	}
    	else if(passTextField.getText().equals(""))
    	{
    		statusLabel.setText("Password field can not be empty");
    		con = false;
    	}
    	return con;
    }
}