/**
	IBM grants you a nonexclusive copyright license to use all programming code 
	examples from which you can generate similar function tailored to your own 
	specific needs.

	All sample code is provided by IBM for illustrative purposes only.
	These examples have not been thoroughly tested under all conditions.  IBM, 
	therefore cannot guarantee or imply reliability, serviceability, or function of 
	these programs.

	All Programs or code component contained herein are provided to you AS IS  
	without any warranties of any kind.
	The implied warranties of non-infringement, merchantability and fitness for a 
	particular purpose are expressly disclaimed.

	 Copyright IBM Corporation 2008, ALL RIGHTS RESERVED.
 */

package sampdita;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

	    /**
	     *  The class for the gui frame
	     */
	    public class DITAToolFrame extends JFrame
	    {
	    	CEConnection ce;
	    	SampDITATool parent;
	    	private JButton closeButton = null;
	    	private JPanel buttonPanel = null;
	    	
	    	/**
	    	 * constructor for the frame
	    	 * @param parentInit
	    	 */
	    	public DITAToolFrame(SampDITATool parentInit, CEConnection ceInit)
	    	{
	    		super("Dita Sample");
	    			    	
	    		ce = ceInit;
	    		parent = parentInit;
	    		
	    		// a border layout container for holding components
	    		Container c = getContentPane();
	    		c.setLayout(new BorderLayout());
	    		
	    		// add the tool panel to the frame at the center to fill the entire window
	    		ToolPanel p = new ToolPanel(parent);
	    		c.add(p,BorderLayout.CENTER);
	    		
	    		c.add(getButtonPanel(), BorderLayout.SOUTH);
	    
	    		// default exit and finalize component layout
	    		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	    		pack();
	    		
	    		// show the window
	    		setVisible(true);
	    	}
	    	
	    	/**
	    	 * This method initializes buttonPanel.	
	    	 * 	
	    	 * @return javax.swing.JPanel	
	    	 */
	    	private JPanel getButtonPanel()
	    	{
	    		if (buttonPanel == null)
	    		{
	    			buttonPanel = new JPanel();
	    			buttonPanel.setLayout(new FlowLayout());
	    			buttonPanel.add(getCloseButton(), null);
	    		}
	    		return buttonPanel;
	    	}
	    	
	    	/**
	    	 * This method initializes closeButton.	
	    	 * 	
	    	 * @return javax.swing.JButton	
	    	 */
	    	private JButton getCloseButton()
	    	{
	    		if (closeButton == null)
	    		{
	    			closeButton = new JButton();
	    			closeButton.setText("Close");
	    			closeButton.addActionListener(new java.awt.event.ActionListener()
	    				{
	    					public void actionPerformed(java.awt.event.ActionEvent e)
	    					{
	    						closeButtonActionPerformed(e);
	    					}
	    				});
	    		}
	    		return closeButton;
	    	}
	    	
	    	/*
	    	 * Action performed on clicking Close button.
	    	 * It closes this JFrame.
	    	 */
	    	private void closeButtonActionPerformed(java.awt.event.ActionEvent e)
	    	{
	    		DITAToolFrame.this.dispose();
	    	}
	    }
	    
	    /**
	     * Class which contains all the gui elements.
	     *
	     */
	    class ToolPanel extends JPanel implements ActionListener
	    {
	    	public static final long serialVersionUID = 1;

	    	// components for upload
	    	SampDITATool parent;

	    	JLabel labelDomain;
	    	JTextField tfDomain;
	    	JLabel labelOS;
	    	JTextField tfOS;
	    	JLabel labelUser;
	    	JTextField tfUser;
	    	JLabel labelP8BaseDir;
	    	JTextField tfP8BaseDir;
	    	JLabel labelLocalDir;
	    	JTextField tfLocalDir;
	    	JLabel labelDitamap;
	    	JTextField tfDitamap;
	    	
	    	JTextArea taStatus;
	    	JScrollPane sp;
	    	
	    	JCheckBox cbSimulate;
	    	JButton butUpload;
	   
	    	// components for download
	    	JLabel labelDlDomain;
	    	JTextField tfDlDomain;
	    	JLabel labelDlOS;
	    	JTextField tfDlOS;
	    	JLabel labelDlP8BaseDir;
	    	JTextField tfDlP8BaseDir;
	    	JLabel labelDlLocalDir;
	    	JTextField tfDlLocalDir;
	    	JLabel labelDlDitamap;
	    	JTextField tfDlDitamap;
	    	JCheckBox cbDlSimulate;
	    	JButton butDownload;
	    	
	    	JTextArea taDlStatus;
	    	JScrollPane spDl;
	    	
	    	/**
	    	 * ToolPanel constructor
	    	 * 
	    	 * @param parentInit
	    	 */
	    	public ToolPanel(SampDITATool parentInit)
	    	{
	    		parent = parentInit;

	    		// set the preferred size of the panel which translates
	    		// to frame size on pack() method call
	    		this.setPreferredSize(new Dimension(400,400));
	    		
	    		setLayout(new GridLayout(1, 1));
	    		
	    		// create a tabbed pane to hold the upload and download
	    		JTabbedPane tabPanel = new JTabbedPane();
	    		
	    		// start by building the upload panel
	    		JPanel uploadPanel = new JPanel();
	    		uploadPanel.setPreferredSize(new Dimension(400,400));
	    		uploadPanel.setLayout(new BorderLayout());
	    		
	    		// create a grid bag panel for the upload data entry
	    		JPanel gp = new JPanel();
	    		GridBagLayout gridbag = new GridBagLayout();
	    		gp.setLayout(gridbag);
	    		GridBagConstraints c = new GridBagConstraints();

	    		// create the domain label and button
	    		c.fill = GridBagConstraints.BOTH;
	    		labelDomain = new JLabel("P8 Domain");
	    		c.weightx = 2.0;
	    		c.gridwidth = 1;
	    		gridbag.setConstraints(labelDomain,c);
	    		gp.add(labelDomain);
	    		
	    		c.gridwidth = GridBagConstraints.REMAINDER;
	    		c.weightx = 5.0;
	    		tfDomain = new JTextField(SampDITATool.DOMAIN_NAME);
	    		gridbag.setConstraints(tfDomain,c);
	    		gp.add(tfDomain);

	    		// create the object store label and input
	    		labelOS = new JLabel("Object Store");
	    		c.weightx = 2.0;
	    		c.gridwidth = 1;
	    		gridbag.setConstraints(labelOS,c);
	    		gp.add(labelOS);
	    		
	    		c.gridwidth = GridBagConstraints.REMAINDER;
	    		c.weightx = 5.0;
	    		tfOS = new JTextField(SampDITATool.OBJECT_STORE_NAME);
	    		gridbag.setConstraints(tfOS,c);
	    		gp.add(tfOS);

	    		// create the user name label and input
	    		labelUser = new JLabel("User");
	    		c.weightx = 2.0;
	    		c.gridwidth = 1;
	    		c.fill = GridBagConstraints.BOTH;
	    		gridbag.setConstraints(labelUser,c);
	    		gp.add(labelUser);
	    		
	    		c.gridwidth = GridBagConstraints.REMAINDER;
	    		c.weightx = 5.0;
	    		tfUser = new JTextField(SampDITATool.USER_NAME);
	    		gridbag.setConstraints(tfUser,c);
	    		gp.add(tfUser);
	    		
	    		// create the upload basedir label and edit
	    		labelP8BaseDir = new JLabel("P8 Base Dir");
	    		c.weightx = 2.0;
	    		c.gridwidth = 1;
	    		c.fill = GridBagConstraints.BOTH;
	    		gridbag.setConstraints(labelP8BaseDir,c);
	    		gp.add(labelP8BaseDir);

	    		c.gridwidth = GridBagConstraints.REMAINDER;
	    		c.weightx = 5.0;
	    		tfP8BaseDir = new JTextField(SampDITATool.p8BaseDir);
	    		gridbag.setConstraints(tfP8BaseDir,c);
	    		gp.add(tfP8BaseDir);

	    		// create the upload local dir label and edit
	    		labelLocalDir = new JLabel("Local Directory");
	    		c.weightx = 2.0;
	    		c.gridwidth = 1;
	    		c.fill = GridBagConstraints.BOTH;
	    		gridbag.setConstraints(labelLocalDir,c);
	    		gp.add(labelLocalDir);
	    		
	    		c.gridwidth = GridBagConstraints.REMAINDER;
	    		c.weightx = 5.0;
	    		tfLocalDir = new JTextField(SampDITATool.baseDir);
	    		gridbag.setConstraints(tfLocalDir,c);
	    		gp.add(tfLocalDir);	    		

	    		// create the ditamap label and edit
	    		labelDitamap = new JLabel("Ditamap");
	    		c.weightx = 2.0;
	    		c.gridwidth = 1;
	    		c.fill = GridBagConstraints.BOTH;
	    		gridbag.setConstraints(labelDitamap,c);
	    		gp.add(labelDitamap);
	    		
	    		c.gridwidth = GridBagConstraints.REMAINDER;
	    		c.weightx = 5.0;
	    		tfDitamap = new JTextField(SampDITATool.filename);
	    		gridbag.setConstraints(tfDitamap,c);
	    		gp.add(tfDitamap);	 	    		
	    		
	    		// add the grid layout to the pane
	    		uploadPanel.add(gp, BorderLayout.NORTH);

	    		// add the simulate and upload buttons to the grid
	    		cbSimulate = new JCheckBox("Simulate");
	    		cbSimulate.setSelected(SampDITATool.simulate);
	    		c.gridwidth=1;
	    		c.gridx = 3;
	    		c.gridy = 9;
	    		c.weightx = 1.0;
	    		gridbag.setConstraints(cbSimulate,c);
	    		gp.add(cbSimulate);	  

	    		butUpload = new JButton("Upload");
	    		butUpload.setActionCommand("upload");
	    		butUpload.addActionListener(this);
	    		c.gridwidth=1;
	    		c.gridx = 4;
	    		c.gridy = 9;
	    		c.weightx = 1.0;
	    		gridbag.setConstraints(butUpload,c);
	    		gp.add(butUpload);	    		
	    		
	    		// add the status area to the bottom
	    		taStatus = new JTextArea();
	    		taStatus.append("DITA Upload Ready\n");
	    		taStatus.setPreferredSize(new Dimension(400,100));
	    		
	    		sp = new JScrollPane(taStatus);
	    		
	    		// setup a filter stream to tee the output to the panel and stdout
	    		FilterOutputStream fos = new FilterOutputStream(System.out) {
	    			public void write(byte b) throws IOException
	    			{
	    				super.write(b);
	    				byte[] b2 = new byte[1];
	    				b2[0] = b;
	    				if (SampDITATool.bUpload)
	    				{
	    					taStatus.append(new String(b2));
		    				sp.revalidate();
		    			}
	    				else
	    				{
	    					taDlStatus.append(new String(b2));
		    				sp.revalidate();
		    			}

	    			}
	    			public void write(byte[] b) throws IOException
	    			{
	    				super.write(b);
	    				if (SampDITATool.bUpload)
	    				{
	    					taStatus.append(new String(b));
		    				sp.revalidate();
		    			}
	    				else
	    				{
	    					taDlStatus.append(new String(b));
		    				sp.revalidate();
		    			}	    			}
	    			public void write(byte[] b, int off, int len) throws IOException
	    			{
	    				super.write(b,off,len);
	    				if (SampDITATool.bUpload)
	    				{
		    				taStatus.append(new String(b).substring(off,len));
		    				taStatus.setRows(taStatus.getRows()+1);
		    				int i = taStatus.getRows();
		    				Dimension d = taStatus.getPreferredScrollableViewportSize();
		    				d = new Dimension(3,3);
		    				sp.revalidate();
	    				}
	    				else
	    				{
		    				taDlStatus.append(new String(b).substring(off,len));
		    				taDlStatus.setRows(taDlStatus.getRows()+1);
		    				int i = taDlStatus.getRows();
		    				Dimension d = taDlStatus.getPreferredScrollableViewportSize();
		    				d = new Dimension(3,3);
		    				spDl.revalidate();	
	    				}
	    			}
	    		};
	    		PrintStream pfos = new PrintStream(fos);
	    		SampDITATool.out = pfos;
	    		
	    		// add the status pane to the bottom of the panel
	    		uploadPanel.add(sp,BorderLayout.CENTER);
	    		
	    		// add the upload panel to the tabbed pane
	    		tabPanel.addTab("Upload", uploadPanel);
	    		
	    		// download panel
	    		JPanel dl = new JPanel();
	    		dl.setLayout(new BorderLayout());
	    		dl.add(new JLabel("Download"),BorderLayout.CENTER);
	    		
	    		// download grid bag panel
	    		JPanel gp2 = new JPanel();
	    		GridBagLayout gridbag2 = new GridBagLayout();
	    		gp2.setLayout(gridbag2);
	    		GridBagConstraints c2 = new GridBagConstraints();

	    		// create the download domain label and edit
	    		c2.fill = GridBagConstraints.BOTH;
	    		labelDlDomain = new JLabel("P8 Domain");
	    		c2.weightx = 2.0;
	    		c2.gridwidth = 1;
	    		gridbag2.setConstraints(labelDlDomain,c2);
	    		gp2.add(labelDlDomain);

	    		c2.gridwidth = GridBagConstraints.REMAINDER;
	    		c2.weightx = 5.0;
	    		tfDlDomain = new JTextField(SampDITATool.DOMAIN_NAME);
	    		gridbag2.setConstraints(tfDlDomain,c2);
	    		gp2.add(tfDlDomain);

	    		// create the download object store label and edit
	    		labelDlOS = new JLabel("Object Store");
	    		c2.weightx = 2.0;
	    		c2.gridwidth = 1;
	    		gridbag2.setConstraints(labelDlOS,c2);
	    		gp2.add(labelDlOS);
	    		
	    		c2.gridwidth = GridBagConstraints.REMAINDER;
	    		c2.weightx = 5.0;
	    		tfDlOS = new JTextField(SampDITATool.OBJECT_STORE_NAME);
	    		gridbag2.setConstraints(tfDlOS,c2);
	    		gp2.add(tfDlOS);

	    		// create the download P8 base dir label and edit
	    		labelDlP8BaseDir = new JLabel("P8 Base Dir");
	    		c2.weightx = 2.0;
	    		c2.gridwidth = 1;
	    		c2.fill = GridBagConstraints.BOTH;
	    		gridbag2.setConstraints(labelDlP8BaseDir,c2);
	    		gp2.add(labelDlP8BaseDir);
	    		
	    		c2.gridwidth = GridBagConstraints.REMAINDER;
	    		c2.weightx = 5.0;
	    		tfDlP8BaseDir = new JTextField(SampDITATool.p8BaseDir);
	    		gridbag2.setConstraints(tfDlP8BaseDir,c2);
	    		gp2.add(tfDlP8BaseDir);

	    		// create the download local dir label and edit
	    		labelDlLocalDir = new JLabel("Download To Dir");
	    		c2.weightx = 2.0;
	    		c2.gridwidth = 1;
	    		c2.fill = GridBagConstraints.BOTH;
	    		gridbag2.setConstraints(labelDlLocalDir,c2);
	    		gp2.add(labelDlLocalDir);
	    		
	    		c2.gridwidth = GridBagConstraints.REMAINDER;
	    		c2.weightx = 5.0;
	    		tfDlLocalDir = new JTextField(SampDITATool.baseDlDir);
	    		gridbag2.setConstraints(tfDlLocalDir,c2);
	    		gp2.add(tfDlLocalDir);	    		

	    		// create the download ditamap file label and edit
	    		labelDlDitamap = new JLabel("Ditamap");
	    		c2.weightx = 2.0;
	    		c2.gridwidth = 1;
	    		c2.fill = GridBagConstraints.BOTH;
	    		gridbag2.setConstraints(labelDlDitamap,c2);
	    		gp2.add(labelDlDitamap);
	    		
	    		c2.gridwidth = GridBagConstraints.REMAINDER;
	    		c2.weightx = 5.0;
	    		tfDlDitamap = new JTextField(SampDITATool.filename);
	    		gridbag2.setConstraints(tfDlDitamap,c2);
	    		gp2.add(tfDlDitamap);	 	    		

	    		// create the simulate download check box and button
	    		cbDlSimulate = new JCheckBox("Simulate");
	    		cbDlSimulate.setSelected(SampDITATool.simulateDl);
	    		c2.gridwidth=1;
	    		c2.gridx = 3;
	    		c2.gridy = 9;
	    		c2.weightx = 1.0;
	    		gridbag2.setConstraints(cbDlSimulate,c2);
	    		gp2.add(cbDlSimulate);	  
	    		
	    		butDownload = new JButton("Download");
	    		butDownload.setActionCommand("download");
	    		butDownload.addActionListener(this);
	    		
	    		c2.gridwidth=1;
	    		c2.gridx = 4;
	    		c2.gridy = 9;
	    		//c.anchor = GridBagConstraints.LAST_LINE_END;
	    		c2.weightx = 1.0;
	    		gridbag2.setConstraints(butDownload,c2);
	    		gp2.add(butDownload);

	    		// add the grid panel to the pane
	    		dl.add(gp2,BorderLayout.NORTH);

	    		// create the download status area
	    		taDlStatus = new JTextArea();
	    		taDlStatus.append("DITA Download Ready\n");
	    		taDlStatus.setPreferredSize(new Dimension(400,100));
	    		//butPanel.add(taStatus,BorderLayout.SOUTH);
	    		
	    		// add the status pane to a scroll pane
	    		spDl = new JScrollPane(taDlStatus);
	    		dl.add(spDl,BorderLayout.CENTER);
	    		
	    		// add them all to the tabbed pane
	    		tabPanel.add("Download",dl);
	    		
	    		// add the tabbed pane to the panel
	    		this.add(tabPanel);
	    	}
	    	
	    	/**
	    	 * perform button action listener events
	    	 */
	    	public void actionPerformed(ActionEvent e)
	    	{
	    		if (e.getActionCommand().equals("upload"))
	    		{
	    			// save all the current values
	    			SampDITATool.DOMAIN_NAME = tfDomain.getText();
	    			SampDITATool.OBJECT_STORE_NAME = tfOS.getText();
	    			SampDITATool.USER_NAME = tfUser.getText();
	    			SampDITATool.p8BaseDir = tfP8BaseDir.getText();
	    			SampDITATool.baseDir = tfLocalDir.getText();
	    			SampDITATool.filename = tfDitamap.getText();
	    			SampDITATool.simulate = cbSimulate.isSelected();
	    	        
	    			SampDITATool.bUpload = true;
	    	        if (SampDITATool.simulate)
	    	        	SampDITATool.out.println("Staring Upload Simulation");
	    	        else
	    	        	SampDITATool.out.println("Starting Upload");
	    	        // kick off the upload
	    	        parent.callEngine(parent);
	    	        if (SampDITATool.simulate)
	    	        	SampDITATool.out.println("Publish Simulation Comple");
	    	        else
	    	        	SampDITATool.out.println("Publish Complete");
	    		}
	    		else if (e.getActionCommand().equals("download"))
	    		{
	    			// save all the current values
	    			SampDITATool.DOMAIN_NAME = tfDlDomain.getText();
	    			SampDITATool.OBJECT_STORE_NAME = tfDlOS.getText();
	    			SampDITATool.p8BaseDir = tfDlP8BaseDir.getText();
	    			SampDITATool.filename = tfDlDitamap.getText();
	    			SampDITATool.baseDlDir = tfDlLocalDir.getText();
	    			SampDITATool.simulateDl = cbDlSimulate.isSelected();
	    	        
	    			SampDITATool.bUpload = false;
	    	        if (SampDITATool.simulateDl)
	    	        	SampDITATool.out.println("Starting Download Simulation");
	    	        else
	    	        	SampDITATool.out.println("Starting Download");
	    	        // kick off the download event
	    	        parent.callEngine(parent);
	    	        if (SampDITATool.simulateDl)
	    	        	SampDITATool.out.println("Download Simulation Complete");
	    	        else
	    	        	SampDITATool.out.println("Download Complete");	    		
	    		}
	
	    		// refill the values in the input components as the tabs should match
	    		// otherwise the two tabs will have different values
	    		// this keeps they synchronized
    	        tfDomain.setText(SampDITATool.DOMAIN_NAME);
    	        tfOS.setText(SampDITATool.OBJECT_STORE_NAME);
    	        tfUser.setText(SampDITATool.USER_NAME);
    	        tfP8BaseDir.setText(SampDITATool.p8BaseDir);
    	        tfDitamap.setText(SampDITATool.filename);
    	        tfLocalDir.setText(SampDITATool.baseDir);
    	        cbSimulate.setSelected(SampDITATool.simulate);
    	        
    	        tfDlDomain.setText(SampDITATool.DOMAIN_NAME);
    	        tfDlOS.setText(SampDITATool.OBJECT_STORE_NAME);
    	        tfDlP8BaseDir.setText(SampDITATool.p8BaseDir);
    	        tfDlDitamap.setText(SampDITATool.filename);
    	        tfDlLocalDir.setText(SampDITATool.baseDlDir);
    	        cbDlSimulate.setSelected(SampDITATool.simulateDl);	    		
	    	}
	    }