/*
*
* Sample program for use with the Product
* Licensed Materials  - Property of IBM
* 5724-I66
* (c) Copyright IBM Corp.  2006, 2009
*   
*/
package com.ibm.wbit.tel.client.jsf.query;

import java.util.ArrayList;

/**
 * This class is to extend where clauses used by the generated client
 * to make sure that only tasks will be found for which the client has
 * been generated for.   
 */
public class ToDosWhereExtension {
    
    /**
     * The names of the tasks the client has been generated for.
     * List must be in synch with list taskNamespaces.
     */
    private ArrayList<String> taskNames;
    
    /**
     * The namespaces of of the tasks the client has been generated for.
     * List must be in synch with list taskNames.
     * 
     */
    private ArrayList<String> taskNamespaces;
    
    /**
     * Get where clause extension to figure out all tasks the client has been generated for.
     * Pattern for returned String is: 
     * TASK_TEMPL.DEFINITION_NAME = 'taskName1' AND TASK_TEMPL.DEFINITION_NS = 'taskNameSpace1' OR 
     * TASK_TEMPL.DEFINITION_NAME = 'taskName2' AND TASK_TEMPL.DEFINITION_NS = 'taskNameSpace2' OR ....
     * 
     * @return where clause extension to figure tasks the client has been generated for.
     */
    public String getWhereClauseExtension() {
        StringBuffer buffer = new StringBuffer();
                
        for (int i=0; i < taskNames.size(); i++) {
            buffer.append("TASK_TEMPL.DEFINITION_NAME = '");
            buffer.append(taskNames.get(i));
            buffer.append("' AND TASK_TEMPL.DEFINITION_NS = '");
            buffer.append(taskNamespaces.get(i));
            buffer.append("'");
        	//not last one ?
        	if ( i != taskNames.size() -1  ) {
        	    buffer.append(" OR ");
        	}
        }
        
        return buffer.toString();
    }
    
    /**
     * The names of the tasks the client has been generated for.
     */
    public ArrayList<String> getTaskNames() {
        return taskNames;
    }
    
    /**
     * The names of the tasks the client has been generated for.
     */
    public void setTaskNames(ArrayList<String> taskNames) {
        this.taskNames = taskNames;
    }
    
    /**
     * The namespaces of the tasks the client has been generated for.
     */
    public ArrayList<String> getTaskNamespaces() {
        return taskNamespaces;
    }
    
    /**
     * The namespaces of the tasks the client has been generated for.
     */
    public void setTaskNamespaces(ArrayList<String> taskNamespaces) {
        this.taskNamespaces = taskNamespaces;
    }
}
