/*
 *
 * Sample program for use with the Product
 * Licensed Materials  - Property of IBM
 * 5724-I66
 * (c) Copyright IBM Corp.  2006, 2009
 *   
 */
package com.ibm.wbit.tel.client.jsf.infrastructure;

import java.util.Locale;

/**
 * This class provides some information about the user, 
 * it can be used to tailor the application to the users needs.
 */
public class UserInfo {
	
    /**
     * Name of the class from the Lotus Forms API to
     * load in order to check if Lotus Forms API is installed.
     */
    private static final String FORMS_CLASS = "com.PureEdge.DTK";


    /**
     * Constructor
     */
    public UserInfo() {
        super();

    }

    /**
     * Return the locale for the user.
     * 
     * @return the locale
     */
    public Locale getLocale() {

        return FacesUtils.getLocale();
    }

    /**
     * Return the name of current user.
     * 
     * @return name of current user.
     */
    public String getName() {
        String name = null;

        if (FacesUtils.getContext() != null) {
            name = FacesUtils.getContext().getRemoteUser();
        }

        return name;
    }

    /**
     * Return if a user logged in.
     * 
     * @return if a user logged in
     */
    public boolean isLoggedIn() {

        if (getName() == null || getName().equals("")) {
            return false;
        } else {
            return true;
        }
    }
    
    /**
     * Checkes if the server API for Forms is available
     * 
     * @return boolean if server API for Forms is available
     */
    public boolean isFormsServerAPIavailable(){
    	
    	boolean available = true;
    	// To check if the Lotus Forms API is installed,
    	// try to dynamically load a Forms class via
    	// reflection.
    	try {
			Class.forName(FORMS_CLASS);
		} catch (final ClassNotFoundException e) {
			available = false;
		}
    	
    	return available;
    }

}