/*
*
* Sample program for use with the Product
* Licensed Materials  - Property of IBM
* 5724-I66
* (c) Copyright IBM Corp.  2006, 2009
*   
*/

package com.ibm.wbit.tel.client.jsf.infrastructure;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;



/**
 * <p>The <code>UnicodeFilter</code> ensures that all incoming requests
 * and outgoing responses use the "UTF-8" character encoding. To use
 * this filter, all JSPs and servlets in the Web application are
 * required to use "UTF-8" internally.</p>
 *
 */
public class UnicodeFilter implements Filter {

	public static final String		UTF8_ENCODING_KEY = "UTF-8" ;
	
	/** Callback when the filter is initialized
	 *
	 * @param config The filter configuration information
	 */
	public void init(FilterConfig config) throws ServletException {
		
		; 	// Do nothing
	}

	/** Filters the request/response chain and hardcodes the UTF-8 character encoding
	 * for <b>all</b> requests and responses.
	 *
	 * @param request	the incoming HTTP request
	 * @param response	the outgoing HTTP response
	 * @param chain		a chain of filters
	 */
	public void doFilter( ServletRequest request, ServletResponse response, FilterChain chain ) throws IOException, ServletException {
		
				
		if( request != null ) {
			request.setCharacterEncoding( UTF8_ENCODING_KEY ) ;
		}
		
		if( response != null ) {
			response.setCharacterEncoding( UTF8_ENCODING_KEY ) ;
		}
		
		// Continue with processing the request/response with the rest of the filter chain.
		//
		if( chain != null ) {
			chain.doFilter( request, response ) ;
		}

		
		
	}

	/** Callback when the filter is destroyed.
	 */
	public void destroy() {
		
		; 	// Do nothing
	}

}
