/*
 *
 * Sample program for use with the Product
 * Licensed Materials  - Property of IBM
 * 5724-I66
 * (c) Copyright IBM Corp.  2006, 2009
 *   
 */
package com.ibm.wbit.tel.client.jsf.infrastructure;

/**
 * This interfaces contains constants which are necessary for multiple classes
 * of the JSF client. Each class that uses at least one of this constants should
 * implement this interface to get direct access to them, rather than use the
 * interface name as prefix all the time.
 */
public interface SharedConstants {

	/**
	 * NLS catalog to use
	 */
	public final static String NLS_CATALOG = "com.ibm.wbit.tel.client.jsf.infrastructure.messages";

	/**
	 * Key available in message properties
	 */
	public final static String QUERY_FAILED_TODOS_OPEN = "QUERY_FAILED_TODOS_OPEN";

	/**
	 * Key available in message properties
	 */
	public final static String QUERY_FAILED_TODOS_CLAIMED = "QUERY_FAILED_TODOS_CLAIMED";

	/**
	 * Key available in message properties
	 */
	public final static String QUERY_FAILED_SUB_TODOS = "QUERY_FAILED_SUB_TODOS";

	/**
	 * Key available in message properties
	 */
	public final static String QUERY_FAILED_BUSINESS_CASE_DETAILS = "QUERY_FAILED_BUSINESS_CASE_DETAILS";
	
	/**
	 * Key available in message properties
	 */
	public final static String QUERY_FAILED_BUSINESS_CASE_STATUS = "QUERY_FAILED_BUSINESS_CASE_STATUS";

	/**
	 * Navigtion rule as of faces config for list with open ToDos
	 */
	public final static String LIST_TODOS_OPEN = "ToDosOpen";

	/**
	 * Navigtion rule as of faces config for list with under work ToDos
	 */
	public final static String LIST_TODOS_UNDER_WORK = "ToDosUnderWork";

	/**
	 * Navigtion rule as of faces config for ToDo to claim
	 */
	public final static String DETAILS_TODOS_OPEN = "ToDoClaim";

	/**
	 * Navigtion rule as of faces config for ToDo to complete
	 */
	public final static String DETAILS_TODO_UNDER_WORK = "ToDoComplete";

	/**
	 * Navigtion rule as of faces config for sub ToDo create
	 */
	public final static String DETAILS_SUB_TODO_CREATE = "SubToDoCreate";

	/**
	 * Navigtion rule as of faces config for BC status check
	 */
	public final static String DETAILS_BUSINESS_CHECK_STATUS = "BCCheckStatus";

	/**
	 * Key available in message properties
	 */
	public final static String WRONG_TASK_MESSAGE_FORMAT = "WRONG_TASK_MESSAGE_FORMAT";

	/**
	 * Key available in message properties
	 */
	public final static String SERVICE_FAILED_HUMAN_TASK_MANAGER = "SERVICE_FAILED_HUMAN_TASK_MANAGER";

	/**
	 * Key available in message properties
	 */
	public final static String SERVICE_FAILED_TO_CLAIM_HUMAN_TASK = "SERVICE_FAILED_TO_CLAIM_HUMAN_TASK";

	/**
	 * Key available in message properties
	 */
	public final static String SERVICE_FAILED_TO_RELEASE_HUMAN_TASK = "SERVICE_FAILED_TO_RELEASE_HUMAN_TASK";

	/**
	 * Key available in message properties
	 */
	public final static String SERVICE_FAILED_TO_COMPLETE_HUMAN_TASK = "SERVICE_FAILED_TO_COMPLETE_HUMAN_TASK";

	/**
	 * Key available in message properties
	 */
	public final static String SERVICE_FAILED_TO_SAVE_HUMAN_TASK = "SERVICE_FAILED_TO_SAVE_HUMAN_TASK";

	/**
	 * Key available in message properties
	 */
	public final static String SERVICE_FAILED_TO_START_HUMAN_TASK = "SERVICE_FAILED_TO_START_HUMAN_TASK";

	/**
	 * Key available in message properties
	 */
	public final static String SERVICE_FAILED_TO_SUSPEND_BUSINESS_PROCESS = "SERVICE_FAILED_TO_SUSPEND_BUSINESS_PROCESS";

	/**
	 * Key available in message properties
	 */
	public final static String SERVICE_FAILED_TO_RESUME_BUSINESS_PROCESS = "SERVICE_FAILED_TO_RESUME_BUSINESS_PROCESS";

	/**
	 * Key available in message properties
	 */
	public final static String SERVICE_FAILED_TO_TERMINATE_BUSINESS_PROCESS = "SERVICE_FAILED_TO_TERMINATE_BUSINESS_PROCESS";

	/**
	 * Key available in message properties
	 */
	public final static String SERVICE_FAILED_TO_DELETE_BUSINESS_PROCESS = "SERVICE_FAILED_TO_DELETE_BUSINESS_PROCESS";

	/**
	 * Key available in message properties
	 */
	public final static String SERVICE_FAILED_TO_START_BUSINESS_PROCESS_NO_MSG = "SERVICE_FAILED_TO_START_BUSINESS_PROCESS_NO_MSG";

	/**
	 * Key available in message properties
	 */
	public final static String SERVICE_FAILED_TO_START_BUSINESS_PROCESS = "SERVICE_FAILED_TO_START_BUSINESS_PROCESS";

	/**
	 * Key available in message properties
	 */
	public final static String NOT_AVAILABLE_ANYMORE_TODO = "NOT_AVAILABLE_ANYMORE_TODO";

	/**
	 * Key available in message properties
	 */
	public final static String TYPE_OF_BUSINESS_CASE_UNKNOWN = "TYPE_OF_BUSINESS_CASE_UNKNOWN";

	/**
	 * Key available in message properties
	 */
	public final static String FAILED_TO_GET_PERSISTED_FORM = "FAILED_TO_GET_PERSISTED_FORM";

	/**
	 * Key available in message properties
	 */
	public final static String FAILED_TO_PERSIST_FORM = "FAILED_TO_PERSIST_FORM";

	/**
	 * Client type JSF
	 */
	public final static String CLIENT_TYPE_JSF = "JSF";

	/**
	 * Client type Forms
	 */
	public final static String CLIENT_TYPE_FORMS = "FORMS";

	/**
	 * The separator for the xpath - xsdtype map
	 */
	public final static String NAVIGATION_SEPARATOR= ">";
	
	/**
	 * The identifier for a single primtive type in a wsdl message.
	 */
	public final static String SINGLE_PRIMITIVE_TYPE = "/SINGLE_PRIMITIVE_TYPE";
	
	
	/**
	 * Suffix to be added to JSF page which is wrapping a pre defined output Form 
	 */
	public static String SUFFIX_JSF_PAGE_WRAPPING_OUTPUT_FORM = "_output";
	
	/**
	 * Suffix to be added to JSF page which is wrapping a pre defined input Form 
	 */
	public static String SUFFIX_JSF_PAGE_WRAPPING_INPUT_FORM = "_input";
}
