/*
*
* Sample program for use with the Product
* Licensed Materials  - Property of IBM
* 5724-I66
* (c) Copyright IBM Corp.  2006, 2009
*   
*/
package com.ibm.wbit.tel.client.jsf.infrastructure;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import com.ibm.bpc.clientcore.exception.CommunicationException;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.clientmodel.HTMConnection;

/**
 * The singleton ServiceFactory manages the references for different Business Process
 * Choreographer modules. <BR>
 * To configure the factory, add a managed bean in one of the JSF configuration
 * files. The managed bean must be named "bfmConnection" and "htmConnection" and
 * have application scope.
 * 
 * See faces-config.xml file for sample configuration.
 * 
 */
public class ServiceFactory {

    /* -- Class variables and methods -- */
    static private	ServiceFactory	instance = null ;

    /** Get the singleton instance 
     * 
     * @return the singleton
     */
    static public ServiceFactory getInstance() {
    	
    	if(instance == null)
    	{
    	    // Make sure that a managed bean with the name ServiceFactory is configured in the faces-config.xml
    	   	instance = (ServiceFactory) FacesUtils.getManagedBeanInstance("ServiceFactory", ServiceFactory.class);
			
        }
    	
        return instance ;
    }
    
    
    /* -- Instance variables and methods --*/
    private	BFMConnection			bfmConnection ;
    private	HTMConnection			htmConnection ;
    
    /** <p>Default C'tor</p>
     */
    public ServiceFactory() {
    }

    /** Returns the underlying connection object
     * 
     * @return the Business Flow Manager connection
     */
    public BFMConnection getBfmConnection() {
        return bfmConnection;
    }

    /** Sets the connection object to determin the service
     * 
     * @param bfmConnection: connection which determines the BusinessFlowManagerService
     */
    public void setBfmConnection(BFMConnection bfmConnection) {
        this.bfmConnection = bfmConnection;
    }
    
    /** Returns the underlying connection object
     * 
     * @return the Human Task Manager connection
     */
    public HTMConnection getHtmConnection() {
        return htmConnection;
    }
    
    /** Sets the connection object to determine the service
     *  
     * @param htmConnection: the connection which determines the HumanTaskManageService
     */
    public void setHtmConnection(HTMConnection htmConnection) {
        this.htmConnection = htmConnection;
    }
    
    /** Returns the Business Flow Manage Service.
     * 
     * @return The BFM service API
     * @throws RemoteException
     * @throws CreateException
     * @throws NamingException
     * @throws CommunicationException 
     */
    public BusinessFlowManagerService getBusinessFlowManagerService() 
    	throws RemoteException, CreateException, NamingException, CommunicationException {
        
        return bfmConnection.getBusinessFlowManagerService() ;
    }

    /** Returns the Human Task Manager Service.
     * 
     * @return The HTM service API
     * @throws RemoteException
     * @throws CreateException
     * @throws NamingException
     * @throws CommunicationException 
     */
    public HumanTaskManagerService getHumanTaskManagerService() 
		throws RemoteException, CreateException, NamingException, CommunicationException {
        
        return htmConnection.getHumanTaskManagerService() ;
    }
}
