/*
*
* Sample program for use with the Product
* Licensed Materials  - Property of IBM
* 5724-I66
* (c) Copyright IBM Corp.  2006, 2009
*   
*/
package com.ibm.wbit.tel.client.jsf.infrastructure;

import java.util.Locale;
import java.util.ResourceBundle;

/**
 * This class is to get the resource bundle according to passed locale. 
 */
public class Messages {
	
	private static final String BUNDLE_NAME = "com.ibm.wbit.tel.client.jsf.infrastructure.messages"; //$NON-NLS-1$
	
	private Messages() {
	}

	
	/**
	 * Get localized message for passed key. 
	 * 
	 * @param key for which to get the message
	 * @param locale for which to get the message
	 * @return localized message for passed key
	 */
	public static String getString(String key, Locale locale) {
		ResourceBundle resourceBundle =  ResourceBundle.getBundle(BUNDLE_NAME, locale);
		
		return resourceBundle.getString(key) ;
	}
	
	/**
	 * This method will replace all replacement variables in the message with the values from 
	 * the array passed into the method. The replacement variables must have the form "{0}", 
	 * "{1}" ...
	 * 
	 * @param key for which to get the message
	 * @param locale for which to get the message
	 * @param values an array of Strings to replace the replacement variables.
	 * @return The localized message with the replaced variables.
	 */
	public static String bind(String key, Locale locale, String[] values){
		String message = getString(key, locale);
		
		for(int i=0; i< values.length; i++){			
			message = message.replace("{" + i + "}", values[i]);
		}
		
		return message;
	}
	
}