/*
*
* Sample program for use with the Product
* Licensed Materials  - Property of IBM
* 5724-I66
* (c) Copyright IBM Corp.  2006, 2009
*   
*/
package com.ibm.wbit.tel.client.jsf.infrastructure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/**
 * ArrayMetaInfo - to administer meta information for arrays.
 */
public class ArrayMetaInfo {
	
	/**
	 * This inner class keeps the real values
	 */
	public class Values {
		
		private int minOccurs = 0, maxOccurs = Integer.MAX_VALUE;
		
		private HashSet<String> keysChildren;

		private List<String> optinalBo = new ArrayList<String>();
		
		public int getMinOccurs() {
			return minOccurs;
		}

		public void setMinOccurs(int minOccurs) {
			this.minOccurs = minOccurs;
		}

		public int getMaxOccurs() {
			return maxOccurs;
		}

		public void setMaxOccurs(int maxOccurs) {
			if (maxOccurs == -1) {
				this.maxOccurs = Integer.MAX_VALUE;
			} else {
				this.maxOccurs = maxOccurs;	
			}			
		}

		public HashSet<String> getKeysChildren() {
			if (keysChildren == null) {
				keysChildren = new HashSet<String>();
			}
			return keysChildren;
		}	
		
		public void addOptionalBO(String xpath){
			this.optinalBo.add(xpath);
		}
		
		public List<String> getOptionalBO(){
			return this.optinalBo;
		}
		
		
	}
		
	/**
	 * The map to administer the values
	 */
	private HashMap<String, Values> metaInfo = new HashMap<String, Values>();
	
	/**
	 * Get the meta info for array associated with passed key.
	 * This meta info is maxOccurs, minOccurs and the keys of all children (nested) arrays. 
	 * 
	 * @param key of the array for which to get the meta information
	 * @return meta info for array associated with passed key
	 */
	public Values getMetaInfo(String key) {
		Values ret =  metaInfo.get(key);
		
		if (ret == null) {
			ret = new Values();
			metaInfo.put(key, ret);			
		}
		return ret; 
	}
	
	/**
	 * Used to initialize managed bean via faces context. With
	 * FacesContext.getCurrentInstance().getApplication().createValueBinding(name);
	 * the managed properties are not initialized.
	 */
	public boolean isInit() {
		return false;
	}
}
