/*
*
* Sample program for use with the Product
* Licensed Materials  - Property of IBM
* 5724-I66
* (c) Copyright IBM Corp.  2006, 2009
*   
*/
package com.ibm.wbit.tel.client.jsf.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.faces.event.ActionEvent;

import com.ibm.bpc.clientcore.Query;
import com.ibm.bpe.jsf.handler.BPCListHandler;
import com.ibm.bpe.jsf.handler.ItemProvider;
import com.ibm.wbit.tel.client.jsf.bean.BCCheckInstance;
import com.ibm.wbit.tel.client.jsf.infrastructure.FacesUtils;
import com.ibm.wbit.tel.client.jsf.infrastructure.Messages;
import com.ibm.wbit.tel.client.jsf.infrastructure.SharedConstants;
import com.ibm.wbit.tel.client.jsf.query.BCCheckStateQuery;


/** 
 * BCCheckHandler acts as listener for command links.
 * It extends  SubviewHandler to bring up a page which shows the 
 * custom properties for the selected action.   
 * Furthermore it is an ItemProvider and can therefore be used as a model 
 * in the command bar component. 
 */
public class BCCheckHandler extends SubviewHandler implements ItemProvider, SharedConstants {

    /**
     * The Business Case that should be created on server.
     */
    private BCCheckInstance bcCheckInstance;
            
    
    /**
     * Action event of a command link.
     * Provide the next subviewIDs and decorate an instance of BCCheckInstance 
     * to check the state of a business case on server. 
     * 
     * @param actionEvent of command link
     */
    public void itemSelected(ActionEvent actionEvent) {

        String componentName, subviewIDCP;
                
        componentName = (String) actionEvent.getComponent().getAttributes().get("componentName");
        subviewIDCP = (String) actionEvent.getComponent().getAttributes().get("searchSubview");
                
        setNavigationInfo(Messages.getString("LINE_BCCHECK_STATE", FacesUtils.getLocale())+" > "+componentName);
        setSubviewIDCustomProperties(subviewIDCP);

        if (bcCheckInstance == null) {
            bcCheckInstance = new BCCheckInstance();
        }
        bcCheckInstance.clearAllValues();
        bcCheckInstance.setComponentName(componentName);

        //do first time refresh using component name
        Object listHandler = FacesUtils.getManagedBeanInstance("bcCheckListHandler", BPCListHandler.class);
        
        Query stateQuery = ((BPCListHandler) listHandler).getQuery();
        ((BCCheckStateQuery) stateQuery).setWhereClause(componentName, null);
        ((BPCListHandler) listHandler).refreshList();
    }
    
    
    /** 
     * Provide the BCCheckInstance selected in the list, e.g. to the command bar component.
	 * @see com.ibm.bpe.jsf.handler.ItemProvider#getSelectedItems()
	 */
	public List<BCCheckInstance> getSelectedItems() {
				
		List<BCCheckInstance> list = Collections.emptyList();
		
		if(bcCheckInstance != null)
		{
			list = new ArrayList<BCCheckInstance>(1);
			list.add(bcCheckInstance);
		}
		return list;
	}
	
	/**
	 * Get the BCCheckInstance selected in list.
	 * 
	 * @return BCCheckInstance
	 */
    public BCCheckInstance getBcCheckInstance() {
        return bcCheckInstance;
    }
       
}
