/*
* Sample program for use with the Product
* Licensed Materials  - Property of IBM
* 5724-I66
* (c) Copyright IBM Corp.  2006, 2009
*   
*/
package com.ibm.wbit.tel.client.jsf.component;

import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.ExternalContext;
import javax.faces.event.FacesEvent;
import javax.servlet.http.HttpServletRequest;

import com.ibm.wbit.tel.client.jsf.infrastructure.FacesUtils;

/**
 * Implementation of CommandLink to identify certain links in JSF pages. 
 */
public class CommandLink extends HtmlCommandLink {

	
	private CommandLink instance;
	
	public static String COMMAND_LINK_KEY = "com.ibm.wbit.tel.client.jsf.component.CommandLink";
	
	/**
	 * Factory method to get an instance. 
	 * 
	 * @return instance of CommandLink
	 */
	public CommandLink getInstance() {
		return instance == null ? new CommandLink() : instance;
	}

	/**
	 * Setter necessary for JSF to restore view. 
	 * 
	 * @param instance of CommandLink
	 */
	public void setInstance(CommandLink instance) {
		this.instance = instance;
	}
	
	/**
	 * Overwrite queueEvent to put a certain key into the request. 
	 */
	public void queueEvent(FacesEvent event) {
						
		if (event.getSource() instanceof CommandLink) {
			ExternalContext extCtx =  FacesUtils.getContext();
			if (extCtx != null) {
				Object request = extCtx.getRequest();
				((HttpServletRequest)request ).setAttribute(COMMAND_LINK_KEY, COMMAND_LINK_KEY);	
			}			
		}
		
		super.queueEvent(event);
	}

}
