/*
*
* Sample program for use with the Product
* Licensed Materials  - Property of IBM
* 5724-I66
* (c) Copyright IBM Corp.  2006, 2009
*   
*/
package com.ibm.wbit.tel.client.jsf.command;


import java.util.List;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.Command;
import com.ibm.task.api.ClientObjectWrapper;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.wbit.tel.client.jsf.bean.ToDoInstance;
import com.ibm.wbit.tel.client.jsf.handler.ToDoMessageHandler;
import com.ibm.wbit.tel.client.jsf.infrastructure.CommandException;
import com.ibm.wbit.tel.client.jsf.infrastructure.ServiceFactory;
import com.ibm.wbit.tel.client.jsf.infrastructure.SharedConstants;

/**
 * The ToDoSave uses the Human Task Manager API to save a previous claimed ToDo.
 * Please refer to the Human Task Manager API for more details.
 * The item provider for the ToDo to release is ToDoMessageHandler. 
 */
public class ToDoSave implements Command, SharedConstants {

    /**
     * Message Handler for open and under work ToDos.
     */
    private ToDoMessageHandler toDoMessageHandler;
        
    /**
     * Executes the save (set output message) command for the selected ToDo.
     * Exceptions to be shown in commandbar will be thrown as CommandException.
     *   
     * 
     * @param items the list of selected items
     * @return next navigation route as defined in faces-config, may be overwritten by action of commandbar
     * @exception CommandException to be shown in commandbar
     * @see com.ibm.bpc.clientcore.Command#execute(java.util.List)
     */
    @SuppressWarnings("unchecked")
	public String execute(List items) throws ClientException {

        if (items != null) {
            HumanTaskManagerService htm;
            //we have only one selected
            Object obj = items.get(0);
            if (obj instanceof ToDoInstance) {
                ToDoInstance toDoInstance = (ToDoInstance) obj;
                String outputMessageType = toDoInstance.getOutputMessageTypeName();
                
                // outputmessage defined and contains values?
				if (outputMessageType != null && toDoInstance.getOutputValuesAll().size() > 0) {
					try {
						htm = ServiceFactory.getInstance().getHumanTaskManagerService();
						
						// get data structure of outputmessage
						ClientObjectWrapper cow = htm.createOutputMessage( toDoInstance.getID() );
						Object dataToSave = toDoInstance.getOutputValuesAll( cow.getObject() );
						
						// save output message
						htm.setOutputMessage(toDoInstance.getID(), new ClientObjectWrapper(dataToSave));
					} catch (Exception e) {
						throw new CommandException(NLS_CATALOG, SERVICE_FAILED_TO_SAVE_HUMAN_TASK, null, e);
					}
				}
            }
        }
        // we always return to that list from which we came and we may have to refresh it
        String lastList = toDoMessageHandler.getLastList();
        
        // to reflect save of the "open ToDo" in list, in case of LIST_TODOS_UNDER_WORK refresh is not necessary  
        if (lastList.equals(LIST_TODOS_OPEN)) {
            toDoMessageHandler.refreshOpenList();
        }
       return lastList; 
    }
    
    /**
     * @see com.ibm.bpc.clientcore.Command#isMultiSelectEnabled()
     */
    public boolean isMultiSelectEnabled() {
        return false;
    }

    /** 
     * @see com.ibm.bpc.clientcore.Command#isApplicable(java.util.List)
     */
    @SuppressWarnings("unchecked")
	public boolean[] isApplicable(List arg0) {
        return (new boolean[0]);
    }

    /**
     * Set context as defined by command bar attribute context.
     * 
     * @param ctx context as defined by command bar attribute context.
     * @see com.ibm.bpc.clientcore.Command#setContext(java.lang.Object)
     */
    public void setContext(Object ctx) {

        toDoMessageHandler = (ToDoMessageHandler) ctx;

    }   

}
