/*
*
* Sample program for use with the Product
* Licensed Materials  - Property of IBM
* 5724-I66
* (c) Copyright IBM Corp.  2009
*
*/
package com.ibm.wbit.tel.client.jsf.command;

import java.util.List;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.Command;
import com.ibm.wbit.tel.client.jsf.bean.ToDoInstance;
import com.ibm.wbit.tel.client.jsf.handler.SubToDoMessageHandler;
import com.ibm.wbit.tel.client.jsf.infrastructure.CommandException;
import com.ibm.wbit.tel.client.jsf.infrastructure.SharedConstants;

/**
 * The SubToDoUseOutput copies the output message of the sub ToDo to
 * the output message of the main ToDo.
 * The item provider for the sub ToDo is SubToDoMessageHandler.
 */
public class SubToDoUseOutput implements Command, SharedConstants {

    /**
     * Message Handler for sub ToDos.
     */
    private SubToDoMessageHandler subToDoMessageHandler;

    /**
     * Executes the copy of sub ToDo output message to main ToDo output message.
     * Exceptions to be shown in commandbar will be thrown as CommandException.
     *
     * @param items the list of selected items
     * @return next navigation route as defined in faces-config, may be overwritten by action of commandbar
     * @exception CommandException to be shown in commandbar
     */
    @SuppressWarnings("unchecked")
	public String execute(List items) throws ClientException {
		if (items != null) {
			Object obj = items.get(0);
			if (obj instanceof ToDoInstance) {
				ToDoInstance mainToDoInstance = (ToDoInstance) obj;
			
				mainToDoInstance.setOutputValuesAll(subToDoMessageHandler.getInitValuesMainOut());
			}
		}
		return DETAILS_TODO_UNDER_WORK;
	}

    /**
	 * @see com.ibm.bpc.clientcore.Command#isMultiSelectEnabled()
	 */
    public boolean isMultiSelectEnabled() {
        return false;
    }

    /**
     * @see com.ibm.bpc.clientcore.Command#isApplicable(java.util.List)
     */
    @SuppressWarnings("unchecked")
	public boolean[] isApplicable(List arg0) {
        return (new boolean[0]);
    }

    /**
     * Set context as defined by command bar attribute context.
     *
     * @param ctx context as defined by command bar attribute context.
     * @see com.ibm.bpc.clientcore.Command#setContext(java.lang.Object)
     */
    public void setContext(Object ctx) {

        subToDoMessageHandler = (SubToDoMessageHandler) ctx;

    }
}
