/*
*
* Sample program for use with the Product
* Licensed Materials  - Property of IBM
* 5724-I66
* (c) Copyright IBM Corp.  2009
*
*/
package com.ibm.wbit.tel.client.jsf.command;

import java.util.List;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.Command;
import com.ibm.task.api.ClientObjectWrapper;
import com.ibm.task.api.HumanTaskManagerService;
import com.ibm.task.api.TKIID;
import com.ibm.wbit.tel.client.jsf.bean.BCCreateInstance;
import com.ibm.wbit.tel.client.jsf.bean.ToDoInstance;
import com.ibm.wbit.tel.client.jsf.handler.BCCreateMessageHandler;
import com.ibm.wbit.tel.client.jsf.infrastructure.CommandException;
import com.ibm.wbit.tel.client.jsf.infrastructure.ServiceFactory;
import com.ibm.wbit.tel.client.jsf.infrastructure.SharedConstants;

/**
 * The SubToDoCreateNew brings up the page to choose a new sub ToDo to be created.
 * It provides also the main ToDo for which to create the sub ToDo.
 * The item provider for the main ToDo is ToDoMessageHandler and for the sub ToDo 
 * to be created it is BCCreateMessageHandler.
 */
public class SubToDoCreateNew implements Command, SharedConstants {
	
		
	/**
	 * Message Handler for create instances
	 */
	BCCreateMessageHandler bcCreateMessageHandler;

    /**
     * Prepares and does sub ToDo creation depending on item provider    
     * Exceptions to be shown in commandbar will be thrown as CommandException.
     *
     * @param items provided by ToDoMessageHandler or BCCreateMessageHandler
     * @return next navigation route as defined in faces-config, may be overwritten by action of commandbar
     * @exception CommandException to be shown in commandbar
     */
    @SuppressWarnings("unchecked")
	public String execute(List items) throws ClientException {
    	String ret = null; 
    	
		if (items != null) {
			Object obj = items.get(0);
			//prepare
			if (obj instanceof ToDoInstance) {
				bcCreateMessageHandler.initSubToDoCreation((ToDoInstance) obj);
				ret = DETAILS_SUB_TODO_CREATE;
			}
			//create
			if (obj instanceof BCCreateInstance) {
				createAndStartHumanTask((BCCreateInstance) obj);
				ret = DETAILS_TODO_UNDER_WORK;
			}
		}
		return ret;
	}

    
    /**
     * Create the standalone originating task or pure human task as sub task.
     *  
     * @param bcCreateInstance to create and start
     * @exception CommandException to be shown in commandbar
     */
    private void createAndStartHumanTask(BCCreateInstance bcCreateInstance) throws ClientException {

        HumanTaskManagerService htm;
        try {
            htm = ServiceFactory.getInstance().getHumanTaskManagerService();
 
            //create the task 
            String name = bcCreateInstance.getComponentName();
            String namespace = bcCreateInstance.getComponentNamespace();
            ToDoInstance mainToDoInstance = bcCreateInstance.getMainToDoInstance();
            TKIID subTaskInstanceID = htm.createTask(name, namespace);
            
            //get data structure of inputmessage
            ClientObjectWrapper cow = htm.createInputMessage( subTaskInstanceID );
            Object dataToStart = bcCreateInstance.getInputValuesAll( cow.getObject() );
            
            //start the task as sub task
            htm.startTaskAsSubTask(subTaskInstanceID, mainToDoInstance.getID(), new ClientObjectWrapper(dataToStart));
        } catch (Exception e) {
            throw new CommandException(NLS_CATALOG, SERVICE_FAILED_TO_START_HUMAN_TASK, null, e);
        }
    }
    
    
    /**
	 * @see com.ibm.bpc.clientcore.Command#isMultiSelectEnabled()
	 */
    public boolean isMultiSelectEnabled() {
        return false;
    }

    /**
     * @see com.ibm.bpc.clientcore.Command#isApplicable(java.util.List)
     */
    @SuppressWarnings("unchecked")
	public boolean[] isApplicable(List arg0) {
        return (new boolean[0]);
    }

    /**
     * Set context as defined by command bar attribute context.
     *
     * @param ctx context as defined by command bar attribute context.
     * @see com.ibm.bpc.clientcore.Command#setContext(java.lang.Object)
     */
    public void setContext(Object ctx) {
    	if ( ctx != null) {
    		bcCreateMessageHandler = (BCCreateMessageHandler) ctx;	
    	}    	
    }

}
