/*
*
* Sample program for use with the Product
* Licensed Materials  - Property of IBM
* 5724-I66
* (c) Copyright IBM Corp.  2009
*   
*/
package com.ibm.wbit.tel.client.jsf.command;

import static com.ibm.wbit.tel.client.jsf.infrastructure.SharedConstants.DETAILS_BUSINESS_CHECK_STATUS;
import static com.ibm.wbit.tel.client.jsf.infrastructure.SharedConstants.NLS_CATALOG;
import static com.ibm.wbit.tel.client.jsf.infrastructure.SharedConstants.SERVICE_FAILED_TO_RESUME_BUSINESS_PROCESS;

import java.util.List;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.Command;
import com.ibm.bpe.api.BusinessFlowManagerService;
import com.ibm.wbit.tel.client.jsf.bean.BCInstance;
import com.ibm.wbit.tel.client.jsf.infrastructure.CommandException;
import com.ibm.wbit.tel.client.jsf.infrastructure.ServiceFactory;

/** 
 * BCResume resumes the instance of a business process that has been started 
 * previously by an inline originating task. 
 */
public class BCResume implements Command {
    
    /**
     * Executes the resume command for the selected Business Case
     * Exceptions to be shown in commandbar will be thrown as CommandException.
     * 
     * @param items the list of selected items
     * @return next navigation route as defined in faces-config, may be overwritten by action of commandbar
     * @exception CommandException to be shown in commandbar
     * @see com.ibm.bpc.clientcore.Command#execute(java.util.List)
     */
    @SuppressWarnings("unchecked")
	public String execute(final List items) throws ClientException {

        if (items != null) {
            //we have only one selected
            final Object obj = items.get(0);
            if (obj instanceof BCInstance) {
                final BCInstance bcInstance = (BCInstance) obj;
                try {
                	final BusinessFlowManagerService bfm = ServiceFactory.getInstance().getBusinessFlowManagerService();
                	bfm.resume(bcInstance.getID());
                } catch (Exception e) {
                    throw new CommandException(NLS_CATALOG, SERVICE_FAILED_TO_RESUME_BUSINESS_PROCESS, null, e);
                }
            }
        }
        return DETAILS_BUSINESS_CHECK_STATUS;
    }
    
    /**
     * @see com.ibm.bpc.clientcore.Command#isMultiSelectEnabled()
     */
    public boolean isMultiSelectEnabled() {
        return false;
    }

    /** 
     * @see com.ibm.bpc.clientcore.Command#isApplicable(java.util.List)
     */
    @SuppressWarnings("unchecked")
	public boolean[] isApplicable(List arg0) {
        return (new boolean[0]);
    }

    /**
     * @see com.ibm.bpc.clientcore.Command#setContext(java.lang.Object)
     */
    public void setContext(Object context) {
    }   
}
