/*
*
* Sample program for use with the Product
* Licensed Materials  - Property of IBM
* 5724-I66
* (c) Copyright IBM Corp.  2006, 2009
*   
*/
package com.ibm.wbit.tel.client.jsf.command;

import java.util.HashMap;
import java.util.List;

import com.ibm.bpc.clientcore.ClientException;
import com.ibm.bpc.clientcore.Command;
import com.ibm.bpc.clientcore.Query;
import com.ibm.bpe.jsf.handler.BPCListHandler;
import com.ibm.wbit.tel.client.jsf.bean.BCCheckInstance;
import com.ibm.wbit.tel.client.jsf.infrastructure.CommandException;
import com.ibm.wbit.tel.client.jsf.infrastructure.SharedConstants;
import com.ibm.wbit.tel.client.jsf.query.BCCheckStateQuery;

/** 
 * BusinessCasesCheck will allows to check the state of a process that has been started 
 * previously by an inline originating task. 
 */
public class BCCheck implements Command, SharedConstants{
    
    /**
     * The list handler of the Business Case Check List.
     */
    private BPCListHandler bcCheckListHandler;
    
    
    /**
     * Executes the refresh command for the selected Business Case
     * Exceptions to be shown in commandbar will be thrown as CommandException.
     * 
     * @param items the list of selected items
     * @return next navigation route as defined in faces-config, may be overwritten by action of commandbar
     * @exception CommandException to be shown in commandbar
     * @see com.ibm.bpc.clientcore.Command#execute(java.util.List)
      */
    @SuppressWarnings("unchecked")
	public String execute(List items) throws ClientException {

        if (items != null) {
            //we have only one selected
            Object obj = items.get(0);
            if (obj instanceof BCCheckInstance) {
                BCCheckInstance bcCheckInstance = (BCCheckInstance) obj;
                                
                refreshList(bcCheckInstance.getComponentName(), bcCheckInstance.getCustomPropertyValues());
            }
        }
        return null;
    }

    /**
     * Refresh the Business Case Check List.
     *
     */
    private void refreshList(String templateName, HashMap<String, String> custPropValues) {
        
        //get current query and enhance it with templateName and custPropValues
        Query query = bcCheckListHandler.getQuery();
                
        if (query instanceof BCCheckStateQuery) {
            BCCheckStateQuery enhancedQuery = (BCCheckStateQuery) query;
            enhancedQuery.setWhereClause(templateName, custPropValues);
            bcCheckListHandler.refreshList();
        }
    }

    
    /**
     * @see com.ibm.bpc.clientcore.Command#isMultiSelectEnabled()
     */
    public boolean isMultiSelectEnabled() {
        return false;
    }

    /** 
     * @see com.ibm.bpc.clientcore.Command#isApplicable(java.util.List)
     */
    @SuppressWarnings("unchecked")
	public boolean[] isApplicable(List arg0) {
        return (new boolean[0]);
    }

    /**
     * The list handler of the Business Case Check List.
     * 
     * @see com.ibm.bpc.clientcore.Command#setContext(java.lang.Object)
     */
    public void setContext(Object context) {
        
        if (context  != null && context instanceof BPCListHandler) {
            bcCheckListHandler = (BPCListHandler) context;
        }
        
    }   
    

}
