package com.ibm.wbit.tel.client.jsf.bean;

import com.ibm.wbit.tel.client.jsf.infrastructure.FacesUtils;
import com.ibm.wbit.tel.client.jsf.infrastructure.Messages;

/**
 * OptionalBoInstance - the data model to store information
 * which optinal nested BO will be rendered.
 */
public class OptionalBoInstance {
	
	/**
	 * A flag to indicate if the optional nested BO should be rendered or not
	 */
	private boolean isVisible = false;
		
	/**
	 * Will be invoked if the user click the command link in the optional nested BO
	 * header.
	 */
	public String show(){
		isVisible = !isVisible;
		return "";
	}
	
	/**
	 * Returns true if the optional nested BO should be shown
	 */
	public boolean isVisible(){
		return isVisible;
	}
	
	
	/**
	 * Sets the visibility of the nested BO
	 */
	public void setVisible(boolean visible){
		 this.isVisible = visible;
	}
	
	/**
	 * Returns the label for the command link
	 */
	public String getLabel(){
		if(isVisible){
			return Messages.getString("MSG_ARRAY_HIDE_ENTRY",FacesUtils.getLocale());
		} else {
			return Messages.getString("MSG_ARRAY_SHOW_ENTRY",FacesUtils.getLocale());
		}
	}
	
	/**
	 * Returns the styled class for the header.
	 */
	public String getStyledClass(){
		if(isVisible){
			return "";
		} else {
			return "Passive";
		}		
	}


}
