/*
*
* Sample program for use with the Product
* Licensed Materials  - Property of IBM
* 5724-I66
* (c) Copyright IBM Corp.  2006, 2009
*   
*/
package com.ibm.wbit.tel.client.jsf.bean;

import java.util.List;
import java.util.Locale;

import com.ibm.bpe.api.ProcessInstanceData;
import com.ibm.bpe.api.QueryResultSet;
import com.ibm.bpe.clientmodel.BFMConnection;
import com.ibm.bpe.clientmodel.bean.ProcessInstanceBean;

/**
 * BCInstance represents an entry in list Business Case check status. 
 */
public class BCInstance extends ProcessInstanceBean {

	private static final long serialVersionUID = 602L;
	
	/**
	 * Real names of custom properties of a process instance.
	 * They are required to return a meaningful label to the
	 * bpe:list tag in BCCheckStatus.jsp.
	 */
	private static String customPropertyName1;
	private static String customPropertyName2;
	private static String customPropertyName3;
	
    /**
	 * Constructs a BCInstance from a ProcessInstanceData object.
	 * 
	 * @param processInstanceData object containing the data represents a row of this result
	 * @param bfmConnection the connection to the Buisness Flow Manager	 
	 */
    public BCInstance(ProcessInstanceData processInstanceData, BFMConnection bfmConnection) {
        super(processInstanceData, bfmConnection);
       
		extractCustomPropertyNames();

    }

    /**
	 * Constructs a BCInstance from a query result set returned by the BuisnessFlowManager API
	 * 
	 * @param resultSet the query result from a query call; represents a row of this result
	 * @param bfmConnection the connection to the Buisness Flow Manager	 
	 */
    public BCInstance(QueryResultSet resultSet, BFMConnection bfmConnection) {
        super(resultSet, bfmConnection);
   
		extractCustomPropertyNames();
    }

	/**
	 * Extract the names of the custom properties of the process instance.
	 */
	@SuppressWarnings("unchecked")
	private void extractCustomPropertyNames() {
		final List<String> customProperties = (List<String>) getNamesOfCustomProperties(); 
		if (customProperties.size() > 0)
		{
			customPropertyName1 = customProperties.get(0);
		}
		if (customProperties.size() > 1)
		{
			customPropertyName2 = customProperties.get(1);
		}
		if (customProperties.size() > 2)
		{
			customPropertyName3 = customProperties.get(2);
		}
	}

    /**
     * Get the value of custom property #1 for this process instance.
     * @return String containing the value.
     */
    public String getCustomProperty1()
    {
    	return getCustomProperty(customPropertyName1);
    }

    /**
     * Get the value of custom property #2 for this process instance.
     * @return String containing the value.
     */
    public String getCustomProperty2()
    {
    	return getCustomProperty(customPropertyName2);
    }

    /**
     * Get the value of custom property #3 for this process instance.
     * @return String containing the value.
     */
    public String getCustomProperty3()
    {
    	return getCustomProperty(customPropertyName3);
    }
    
   /** 
    * Returns the resource bundle key for a property
    * 
    * @param propertyName the name of the property.
    * @return the resource bundle key for the property.
    * This implementation returns the real name of a custom property
    * because custom properties are process instance specific and have
    * no translated label. For regular properties, the corresponding label
    * is returned.

    */
   static public String getLabel(final String propertyName) {
     String label = null;
     
     if ("customProperty1".equals(propertyName) && customPropertyName1 != null)
     {
    	 label = customPropertyName1;
     }
     else if ("customProperty2".equals(propertyName) && customPropertyName2 != null)
     {
    	 label = customPropertyName2;
     }
     else if ("customProperty3".equals(propertyName) && customPropertyName3 != null)
     {
    	 label = customPropertyName3;
     }
     else
     {
    	 label = ProcessInstanceBean.getLabel(propertyName);
     }
     
     return label;
   }

   /**
    * Returns the label for a property from the resource bundle. If no label is
    * found in the resource bundle, the resource bundle key for the property is
    * returned.<br>
    * This implementation returns the real name of a custom property
    * because custom properties are process instance specific and have
    * no translated label. For regular properties, the corresponding label
    * is returned.
    * 
    * @param propertyName the name of the property.
    * @param locale the locale.
    * @return The label or resource bundle key for the property.
    */
   static public String getLabel(final String propertyName, final Locale locale) {
	     String label = null;
	     
	     if ("customProperty1".equals(propertyName) && customPropertyName1 != null)
	     {
	    	 label = customPropertyName1;
	     }
	     else if ("customProperty2".equals(propertyName) && customPropertyName2 != null)
	     {
	    	 label = customPropertyName2;
	     }
	     else if ("customProperty3".equals(propertyName) && customPropertyName3 != null)
	     {
	    	 label = customPropertyName3;
	     }
	     else
	     {
	    	 label = ProcessInstanceBean.getLabel(propertyName, locale);
	     }
	     
	     return label;
   }
}
