/*
 *
 * Sample program for use with the Product
 * Licensed Materials  - Property of IBM
 * 5724-I66
 * (c) Copyright IBM Corp.  2006, 2009
 *   
 */
package com.ibm.wbit.tel.client.jsf.bean;

import java.util.HashMap;


/**
 * BCCheckInstance represents a Business Case whose state should be checked on server.
 */
public class BCCheckInstance {
   	
	/**
     * The value map which contains the values of the custom properties. 
     * They can be set by JSF pages. 
     */
	private HashMap<String, String> customPropertyValues = null;
		 
    /**
     * The component name of the Business Case to create
     */
	private String componentName = null;

	
	/**
	 * Constructor
	 */
	public BCCheckInstance() {
	    super();
	    customPropertyValues = new HashMap<String, String>();
	}
	
	/**
	 * Clear all values of this instance
	 */
	public void clearAllValues(){
	    customPropertyValues.clear();
	    componentName = null; 
	  
	}
  
    
    /**
     * Get the value map which contains the values of the custom properties.  
     * They can be set by JSF pages. 
     * 
     * @return the value map which contains the values of the custom properties
     */
    public HashMap<String, String> getCustomPropertyValues() {
        return customPropertyValues;
    }
    
     
    /**
     * Get the component name of this Business Case
     * 
     * @return component name of this Business Case
     */
    public String getComponentName() {
        return componentName;
    }
    
    /**
     * Set the component name of this Business Case
     * 
     * @param component name of this Business Case
     */
    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }
   
}
