<HTML>

<!--

Sample program for use with the Product
Licensed Materials  - Property of IBM
5724-I66
(c) Copyright IBM Corp.  2008
   
-->

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://com.ibm.bpe.jsf/taglib" prefix="bpe"%>
<jsp:useBean id="subToDoMessageHandler" scope="session" class="com.ibm.wbit.tel.client.jsf.handler.SubToDoMessageHandler" />
<f:subview id="SubToDoList">
<f:loadBundle basename="com.ibm.wbit.tel.client.jsf.infrastructure.messages" var="bundle" />

	<%
		subToDoMessageHandler.refreshList();
	%>	
		<h:panelGrid styleClass="BackgroundViewMTD">
			<h:panelGrid styleClass="BackgroundSubViewMTD" columns="1">
				<h:outputText styleClass="ViewLabelMTD" value="#{bundle['MSG_SUBVIEW_SUBTODO_MESSAGE']}"/>
				<bpe:list model="#{subToDosListHandler}" styleClass="list"
					rows="20" headerStyleClass="template-headers"
					buttonStyleClass="list-buttons" checkbox="false">
					<bpe:column name="name" action="SubToDoDetails" />
					<bpe:column name="description"  />
					<bpe:column name="firstActivationTime"  />
					<bpe:column name="state"  />
					<bpe:column name="lastModificationTime" />
					<bpe:column name="lastStateChangeTime" />
					<bpe:column name="originator"  />
				</bpe:list>
			</h:panelGrid>
		</h:panelGrid>

		<h:panelGrid styleClass="commandbar">
			<bpe:commandbar model="#{toDoMessageHandler}" buttonStyleClass="button">
				<bpe:command label="#{bundle['BUTTON_REFRESH']}" commandID="RefreshSubToDosList" 
				    action="#{subToDoMessageHandler.refreshList}" 
				    immediate="true" />
			    <bpe:command label="#{bundle['BUTTON_CREATE']}" commandID="SubToDoInitCreateNew"
					commandClass="com.ibm.wbit.tel.client.jsf.command.SubToDoCreateNew" 
					context="#{bcCreateMessageHandler}"
					immediate="true" />
			</bpe:commandbar>
		</h:panelGrid>
	
</f:subview>
</HTML>

