<HTML>

<!--

Sample program for use with the Product
Licensed Materials  - Property of IBM
5724-I66
(c) Copyright IBM Corp.  2008
   
-->

<HEAD>
<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://com.ibm.bpe.jsf/taglib" prefix="bpe"%>
<jsp:useBean id="bcDetailsHandler" scope="session" class="com.ibm.wbit.tel.client.jsf.handler.BCDetailsHandler" />
<%
	String contextPath = request.getContextPath();
%>
<link href=<%=contextPath+"/theme/styles.css"%> rel="stylesheet" type="text/css">
<title>Business Cases Details</title>
</HEAD>
<f:view locale="#{userInfo.locale}">
<f:loadBundle basename="com.ibm.wbit.tel.client.jsf.infrastructure.messages" var="bundle" />
<BODY class="NavigationBackgroundLeft">
 
 <table cellpadding="0" cellspacing="0" width="100%">
  <tr>
   <td class="Banner" colspan="2" >		
      <jsp:include page="Banner.jsp" flush="true" />
   </td>
  </tr>
  <tr valign="top">
   <td nowrap="nowrap" width="220">
   	  <jsp:include page="Content.jsp" flush="true" />
   </td>
   <td>
	<h:form styleClass="BackgroundView">
		<h:panelGrid styleClass="BackgroundViewBC" columns="1">
			<h:outputText styleClass="ViewHeadingBC" value="#{bcDetailsHandler.navigationInfo}" />
			<h:outputText styleClass="SelectStatement" value="#{bundle['LINE_BCDETAILS_STATE_DESCR']}" />
		</h:panelGrid>
			

		<h:panelGrid styleClass="BackgroundViewBC" columns="1">
			<h:outputText styleClass="ViewHeadingBC" value="#{bundle['LINE_BCDETAILS']}" />
			<h:panelGrid styleClass="BackgroundSubViewBC" columns="1">
				<bpe:details model="#{BCInstanceDetails}" styleClass="list">
					<bpe:property name="name" />
					<bpe:property name="description" />
					<bpe:property name="executionState" />
					<bpe:property name="startTime" />
					<bpe:property name="completionTime" />
					<bpe:property name="starter" />
			   </bpe:details>
			</h:panelGrid>
		</h:panelGrid>

		<h:panelGrid styleClass="BackgroundViewBC" columns="1">
			<h:outputText styleClass="ViewHeadingBC" value="#{bundle['MSG_SUBVIEW_INPUT_MESSAGE']}" />
			<%
				final String subviewIDInput = bcDetailsHandler.getSubviewIDInput()+ ".jsp";
			%> 
			<jsp:include page="<%=subviewIDInput%>" flush="true" />
		</h:panelGrid>			

		<h:panelGrid styleClass="BackgroundViewBC" columns="1" rendered="#{bcDetailsHandler.outputMessageDefined}">
			<h:outputText styleClass="ViewHeadingBC" value="#{bundle['MSG_SUBVIEW_OUTPUT_MESSAGE']}" />
			<%
		 		if (bcDetailsHandler.isFinished() && bcDetailsHandler.getSubviewIDOutput() != null) {
					final String subviewIDOutput = bcDetailsHandler.getSubviewIDOutput()+ ".jsp";
			%> 
				<jsp:include page="<%=subviewIDOutput%>" flush="true" />
			<%
				}
			%>
		</h:panelGrid>
		
		<h:outputText rendered="#{bcDetailsHandler.terminated}" styleClass="StatusStatement" value="#{bundle['MSG_BCDETAILS_PROCESS_TERMINATED']}" />
		<h:outputText rendered="#{!bcDetailsHandler.finished && !bcDetailsHandler.terminated}" styleClass="StatusStatement" value="#{bundle['MSG_BCDETAILS_PROCESS_NOT_FINISHED']}" />

		<h:panelGrid styleClass="commandbar" columns="1">
			<bpe:commandbar model="#{bcDetailsHandler}" buttonStyleClass="button">
				<bpe:command rendered="#{bcDetailsHandler.running}"
					label="#{bundle['BUTTON_SUSPEND']}" commandID="SuspendBC"
					action="#{bcCheckListHandler.refreshList}"
					commandClass="com.ibm.wbit.tel.client.jsf.command.BCSuspend" /> 
				<bpe:command rendered="#{bcDetailsHandler.suspended}"
					label="#{bundle['BUTTON_RESUME']}" commandID="ResumeBC"
					action="#{bcCheckListHandler.refreshList}"
					commandClass="com.ibm.wbit.tel.client.jsf.command.BCResume" /> 
				<bpe:command rendered="#{bcDetailsHandler.terminatable}"
					label="#{bundle['BUTTON_TERMINATE']}" commandID="TerminateBC"
					action="#{bcCheckListHandler.refreshList}"
					commandClass="com.ibm.wbit.tel.client.jsf.command.BCTerminate" /> 
				<bpe:command rendered="#{bcDetailsHandler.deletable}"
					label="#{bundle['BUTTON_DELETE']}" commandID="DeleteBC"
					action="#{bcCheckListHandler.refreshList}"
					commandClass="com.ibm.wbit.tel.client.jsf.command.BCDelete" /> 
			</bpe:commandbar>
		</h:panelGrid>
			
	</h:form>
   </td>
   </tr>
  </table>
 </BODY>
</f:view>
</HTML>