HxG_6.prototype.XMLData=function(node, cloneNode)
{
if (typeof node == "string")
{
var xmlDoc;
if (hX_6.brw.isIE())
{
xmlDoc=new ActiveXObject("Microsoft.XMLDOM");
xmlDoc.loadXML(node);
}
else if (hX_6.brw.isNavOrMoz())
{
var xmlParser=new DOMParser();
xmlDoc=xmlParser.parseFromString(node, "text/xml");
}
this.xmlNode=xmlDoc.documentElement;
}
else
 {
if(!node)
{
var args=[];
args[0]="node";
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_param, args);
Log.error("HxG_6.XMLData", Msg);
throw new hX_6.XMLDataError(Msg);
}
else
 {
this.isRootOfXMLDocument=false;
switch(node.nodeType){
case this.ELEMENT_NODE:
case this.ATTRIBUTE_NODE:
case this.TEXT_NODE:
case this.CDATA_NODE:
case this.ENTITY_REFERENCE_NODE:
case this.ENTITY_NODE:
case this.PROCESSING_INSTRUCTION_NODE:
case this.COMMENT_NODE:
case this.DOCUMENT_FRAGMENT_NODE:
case this.NOTATION_NODE:
this.xmlNode=(cloneNode) ? node.cloneNode(true) : node;
break;
case this.DOCUMENT_NODE:
this.xmlNode=(cloneNode) ? node.documentElement.cloneNode(true) : node.documentElement;
this.isRootOfXMLDocument=true;
break;
default:
break;
}
}
}
this.prettyPrinting=true;
this.prettyIndent=2;
}
HxG_6.prototype.XMLData.prototype.ELEMENT_NODE=1;
HxG_6.prototype.XMLData.prototype.ATTRIBUTE_NODE=2;
HxG_6.prototype.XMLData.prototype.TEXT_NODE=3;
HxG_6.prototype.XMLData.prototype.CDATA_NODE=4;
HxG_6.prototype.XMLData.prototype.ENTITY_REFERENCE_NODE=5;
HxG_6.prototype.XMLData.prototype.ENTITY_NODE=6;
HxG_6.prototype.XMLData.prototype.PROCESSING_INSTRUCTION_NODE=7;
HxG_6.prototype.XMLData.prototype.COMMENT_NODE=8;
HxG_6.prototype.XMLData.prototype.DOCUMENT_NODE=9;
HxG_6.prototype.XMLData.prototype.DOCUMENT_TYPE_NODE=10;
HxG_6.prototype.XMLData.prototype.DOCUMENT_FRAGMENT_NODE=11;
HxG_6.prototype.XMLData.prototype.NOTATION_NODE=12;
HxG_6.prototype.XMLData.prototype.addNameSpace=function(namespaceToAdd)
{
}
HxG_6.prototype.XMLData.prototype.getNumChildrenOfRoot=function()
{
return this.xmlNode.childNodes.length;
}
HxG_6.prototype.XMLData.prototype.appendChild=function(childToAppend)
{
if(!childToAppend)
{
var args=[];
args[0]="childToAppend";
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_param, args);
Log.error("HxG_6.XMLData.appendChild", Msg);
throw new hX_6.XMLDataError(Msg);
}
else
 {
if(childToAppend instanceof hX_6.XMLData)
{
var newch=childToAppend.copy();
this.xmlNode.appendChild(newch.xmlNode);
}
else if(childToAppend instanceof hX_6.XMLDataList)
{
var i, newch=childToAppend.copy();
for(i=0; i<newch.length(); i++)
{
this.appendChild(newch.elementByIndex(i));
}
}
else
 {
var args=[];
args[0]="childToAppend";
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_param_type, args);
Log.error("HxG_6.XMLData.appendChild", Msg);
throw new hX_6.XMLDataError(Msg);
}
}
}
HxG_6.prototype.XMLData.prototype.attribute=function(attributeName)
{
if(this.xmlNode.nodeType!=this.ELEMENT_NODE)
{
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_xmldata_not_element);
Log.error("HxG_6.XMLData.attribute", Msg);
throw new hX_6.XMLDataError(Msg);
return null;
}
var attr=this.xmlNode.getAttributeNode(attributeName);
return new hX_6.XMLData(attr);
}
HxG_6.prototype.XMLData.prototype.attributes=function()
{
if(this.xmlNode.nodeType!=this.ELEMENT_NODE)
{
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_xmldata_not_element);
Log.error("HxG_6.XMLData.attributes", Msg);
throw new hX_6.XMLDataError(Msg);
return null;
}
var attrs=this.xmlNode.attributes;
return new hX_6.XMLDataList(attrs);
}
HxG_6.prototype.XMLData.prototype.child=function(childPropertyName)
{
if(this.xmlNode.hasChildNodes())
{
var children=this.xmlNode.childNodes;
if(typeof childPropertyName == "number")
{
if (childPropertyName >= 0 && childPropertyName < children.length)
{
var elem=children.item(childPropertyName);
var arr=[];
return new hX_6.XMLData(elem);
}
else
 {
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_index);
Log.error("HxG_6.XMLData.child", Msg);
throw new hX_6.XMLDataError(Msg);
return null;
}
}
else if (typeof childPropertyName == "string")
{
var curr;
var arr=[];
for (i=0; i<children.length; i++)
{
curr=children.item(i);
if (curr.nodeName == childPropertyName)
{
arr[arr.length]=new hX_6.XMLData(curr);
}
}
var result=new hX_6.XMLDataList(arr);
return result;
}
else
 {
var args=[];
args[0]="childPropertyName";
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_param_type,args);
Log.error("HxG_6.XMLData.child", Msg);
throw new hX_6.XMLDataError(Msg);
return null;
}
}
else
 {
return new hX_6.XMLDataList();
}
}
HxG_6.prototype.XMLData.prototype.children=function()
{
if(this.xmlNode.hasChildNodes())
{
var i,
children=this.xmlNode.childNodes,
child_elems=[];
for (i=0; i<children.length; i++)
{
child_elems[i]=new hX_6.XMLData(children.item(i));
}
return new hX_6.XMLDataList(child_elems);
}
else
 {
return new hX_6.XMLDataList();
}
}
HxG_6.prototype.XMLData.prototype.contains=function(value)
{
if(value)
{
var result=(this == value) ? true : false;
return result;
}
else
 {
var args=[];
args[0]="value";
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_param, args);
Log.error("HxG_6.XMLData.contains", Msg);
throw new hX_6.XMLDataError(Msg);
}
}
HxG_6.prototype.XMLData.prototype.copy=function()
{
return (new hX_6.XMLData(this.xmlNode,true));
}
HxG_6.prototype.XMLData.prototype.getDescendants=function(name)
{
if (!this.xmlNode.hasChildNodes())
{
return null;
}else{
var i, ch=this.children(), desc=new hX_6.XMLDataList(new Array());
for (i=0; i<ch.length(); i++)
{
var curr=ch.elementByIndex(i), new_desc;
if(!name)
{
desc.append(curr);
new_desc=curr.getDescendants();
}
else
 {
if (name==curr.name()){
desc.append(curr);
}
new_desc=curr.getDescendants(name);
}
if(new_desc)
{
desc.append(new_desc);
}
}
return desc;
}
}
HxG_6.prototype.XMLData.prototype.elements=function(name)
{
var result=new hX_6.XMLDataList(new Array());
if(!this.xmlNode.hasChildNodes())
{
Log.info("HxG_6.XMLData.elements", "No children found");
}
else
 {
var ch=this.children(), i;
if(name)
{
Log.info("HxG_6.XMLData.elements", "Looking for elements with name '" + name + "'");
for (i=0; i<ch.length(); i++)
{
var curr=ch.elementByIndex(i);
if (curr.name() == name && curr.type() == curr.ELEMENT_NODE)
{
result.append(curr);
}
}
}
else
 {
Log.info("HxG_6.XMLData.elements", "No name specified so retrieving all elements");
for (i=0; i<ch.length(); i++)
{
var curr=ch.elementByIndex(i);
if (curr.type() == curr.ELEMENT_NODE)
{
result.append(curr);
}
}
}
}
return result;
}
HxG_6.prototype.XMLData.prototype.inScopeNamespaces=function()
{
}
HxG_6.prototype.XMLData.prototype.insertChildAfter=function(referenceNode, childToInsert)
{
}
HxG_6.prototype.XMLData.prototype.insertChildBefore=function()
{
}
HxG_6.prototype.XMLData.prototype.length=function()
{
var result=1;
return result;
}
HxG_6.prototype.XMLData.prototype.localName=function()
{
}
HxG_6.prototype.XMLData.prototype.name=function()
{
var name=this.xmlNode.nodeName;
if (name == "#text" ||
name == "#cdata-section" ||
name == "#comment" ||
name == "#document" ||
name == "#document-fragment")
{
return null;
}
else
 {
return this.xmlNode.nodeName;
}
}
HxG_6.prototype.XMLData.prototype.value=function()
{
var t=this.type();
if (t == this.TEXT_NODE ||
t == this.COMMENT_NODE ||
t == this.PROCESSING_INSTRUCTION_NODE ||
t == this.ATTRIBUTE_NODE)
{
return this.xmlNode.nodeValue;
}
else
 {
return null;
}
}
HxG_6.prototype.XMLData.prototype.namespace=function(prefix)
{
}
HxG_6.prototype.XMLData.prototype.namespaceDeclarations=function()
{
}
HxG_6.prototype.XMLData.prototype.prependChild=function(childToPrepend)
{
if (!childToPrepend)
{
var args=[];
args[0]="childToPrepend";
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_param, args);
Log.error("HxG_6.XMLData.prependChild", Msg);
throw new hX_6.XMLDataError(Msg);
}
else if(childToPrepend instanceof hX_6.XMLData)
{
var newch=childToPrepend.copy();
if(this.xmlNode.firstChild){
this.xmlNode.insertBefore(newch.xmlNode, this.xmlNode.firstChild);
}else{
this.xmlNode.appendChild(newch.xmlNode);
}
}
else if(childToPrepend instanceof hX_6.XMLDataList)
{
var newch=childToPrepend.copy();
var i;
for(i=0; i<newch.length(); i++)
{
this.xmlNode.insertBefore(newch.elementByIndex(childToPrepend.length()-1-i).xmlNode, this.xmlNode.firstChild);
}
}
else
 {
var args=[];
args[0]="childToPrepend";
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_param_type, args);
Log.error("HxG_6.XMLData.prependChild", Msg);
throw new hX_6.XMLDataError(Msg);
}
}
HxG_6.prototype.XMLData.prototype.put=function(P, V)
{
var c, notXMLType=!((V instanceof hX_6.XMLData) || (V instanceof hX_6.XMLDataList));
if (notXMLType || (V.type() == this.TEXT_NODE) || (V.type() == this.ATTRIBUTE_NODE))
{
c=V.toString();
}
else
 {
c=V.copy(true);
}
var t=this.type();
if (t == this.TEXT_NODE || t == this.COMMENT_NODE || t == this.PROCESSING_INSTRUCTION_NODE || t == this.ATTRIBUTE_NODE)
{
return;
}
if(P.charAt(0) == '@')
{
}
var i=null;
var primitiveAssign=(notXMLType && (P != "*"));
var k, len=this.children().length();
for (k=len-1; k>=0; k--)
{
if ((P == "*") || ((this.child(k).type() == this.ELEMENT_NODE) && (this.child(k).name() == P)))
{
if (i)
{
this.removeByIndex(i);
}
i=k;
}
}
if (!i)
{
i=len;
if (primitiveAssign == true)
{
var newch=new hX_6.XMLData("<"+P+" />");
this.replace(i,newch);
}
}
if (primitiveAssign == true)
{
this.child(i).remove("*");
var s=c.toString();
if (s!="")
{
this.child(i).replace(0,s);
}
}
else
 {
this.replace(i,c);
}
return;
}
HxG_6.prototype.XMLData.prototype.replace=function(P,V)
{
var t=this.type();
if (t == this.TEXT_NODE || t == this.COMMENT_NODE || t == this.PROCESSING_INSTRUCTION_NODE || t == this.ATTRIBUTE_NODE)
{
return;
}
var ch=this.children();
var len=ch.length();
if (P >= len)
{
P=len;
}
if (V instanceof hX_6.XMLData)
{
var t2=V.type();
if(t2 == this.ELEMENT_NODE || t2 == this.COMMENT_NODE || t2 == this.PROCESSING_INSTRUCTION_NODE || t2 == this.TEXT_NODE){
var old=this.xmlNode.childNodes.item(P);
if(P==len)
{
this.appendChild(V);
}
else
 {
this.xmlNode.replaceChild(V.xmlNode,old);
}
}
}
else if (V instanceof hX_6.XMLDataList)
{
this.deleteByIndex(P);
}
else
 {
var s=V.toString(), txt;
var newtext=new hX_6.XMLData(this.xmlNode.ownerDocument.createTextNode(s));
var old=this.xmlNode.childNodes.item(P);
if(P==len)
{
this.appendChild(newtext);
}
else
 {
this.xmlNode.replaceChild(old,newtext);
}
}
}
HxG_6.prototype.XMLData.prototype.removeNamespace=function(namespace)
{
}
HxG_6.prototype.XMLData.prototype.remove=function(P)
{
if (!P)
{
var args=[];
args[0]="P";
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_param, args);
Log.error("HxG_6.XMLData.remove", Msg);
throw new hX_6.XMLDataError(Msg);
}
else
 {
if (P.charAt(0) == '@')
{
var attrs=this.attributes(), name=P.substr(1), i;
for (i=0; i<attrs.length(); i++)
{
if ((P=="*")
|| (name == attrs.elementByIndex(i).name()))
{
this.xmlNode.removeAttribute(attrs.elementByIndex(i).name());
}
}
}
else
 {
var dp=0;
var ch=this.children();
for (i=0; i<ch.length(); i++)
{
var curr=ch.elementByIndex(i);
if (P == "*" || (curr.type() == this.ELEMENT_NODE && curr.name() == P))
{
this.xmlNode.removeChild(curr.xmlNode);
}
}
}
}
}
HxG_6.prototype.XMLData.prototype.removeByIndex=function(P)
{
var ch=this.children();
if (P<0 || P >= ch.length())
{
var args=[];
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_index, args);
Log.error("HxG_6.XMLData.removeByIndex", Msg);
throw new hX_6.XMLDataError(Msg);
}
else
 {
this.xmlNode.removeChild(this.xmlNode.childNodes.item(P));
}
}
HxG_6.prototype.XMLData.prototype.setChildren=function(value)
{
if(this instanceof hX_6.XMLData)
{
}
else if(this instanceof hX_6.XMLDataList)
{
}
else
 {
Log.error("HxG_6.XMLData.setChildren","");
}
}
HxG_6.prototype.XMLData.prototype.setNamespace=function(namespace)
{
}
HxG_6.prototype.XMLData.prototype.text=function()
{
var arr=[];
if (this.xmlNode.hasChildNodes())
{
var children=this.children();
for (i=0; i<children.length(); i++)
{
var curr=children.elementByIndex(i).xmlNode;
if (curr.nodeType == this.TEXT_NODE)
{
arr[arr.length]=new hX_6.XMLData(curr);
}
}
}
var result=new hX_6.XMLDataList(arr);
return result;
}
HxG_6.prototype.XMLData.prototype.toString=function()
{
var t=this.type();
if ((t == this.ATTRIBUTE_NODE) || (t == this.TEXT_NODE))
{
return this.value();
}
if (this.hasSimpleContent())
{
var i, ch=this.children(), s="";
for (i=0; i<ch.length(); i++)
{
var curr=ch.elementByIndex(i);
var t=curr.type();
if ((t != this.PROCESSING_INSTRUCTION_NODE) && (t != this.COMMENT_NODE))
{
s+=ch.elementByIndex(i).toString();
}
}
return s;
}
else
 {
return this.toXMLString();
}
}
HxG_6.prototype.XMLData.prototype.toXMLString=function(IndentLevel)
{
var str="", i;
if (!IndentLevel)
{
IndentLevel=0;
}
if (this.prettyPrinting)
{
for (i=0; i<IndentLevel; i++)
{
str+=" ";
}
}
switch (this.type())
{
case this.TEXT_NODE:
if (this.prettyPrinting)
{
var v=this.trimWhitespace(this.value());
return str + this.EscapeElementValue(v);
}
else
 {
return this.EscapeElementValue(this.value());
}
break;
case this.ATTRIBUTE_NODE:
return this.value();
break;
case this.COMMENT_NODE:
return (str + "<!--" + this.value() + "-->");
break;
case this.PROCESSING_INSTRUCTION_NODE:
return (str + "<?" +  this.name() + " " + this.value() + "?>");
break;
}
str+="<" + this.name();
var	attrs=this.attributes();
for (i=0; i<attrs.length(); i++)
{
var curr=attrs.elementByIndex(i);
str+=' ' + curr.name() + '="' + curr.value() + '"';
}
var ch=this.children();
if (ch.length() == 0)
{
return (str + " />");
}
else
 {
str+=">";
}
var indentChildren=((ch.length()>1) || (ch.length() == 1 && ch.elementByIndex(0).type() != this.TEXT_NODE)),
nextIndentLevel;
if (this.prettyPrinting && indentChildren)
{
nextIndentLevel=IndentLevel + this.prettyIndent;
}
else
 {
nextIndentLevel=0;
}
for (i=0; i<ch.length(); i++)
{
if (this.prettyPrinting && indentChildren)
{
str+="\n";
}
str+=ch.elementByIndex(i).toXMLString(nextIndentLevel)
}
if (this.prettyPrinting && indentChildren)
{
str+="\n";
for (i=0; i<IndentLevel; i++)
{
str+=" ";
}
}
str+="</" +  this.name() + ">";
return str;
}
HxG_6.prototype.XMLData.prototype.type=function(){
return this.xmlNode.nodeType;
}
HxG_6.prototype.XMLData.prototype.value=function(){
return this.xmlNode.nodeValue;
}
HxG_6.prototype.XMLData.prototype.hasSimpleContent=function()
{
var t=this.xmlNode.nodeType, result;
if((t == this.COMMENT_NODE) || (t == this.PROCESSING_INSTRUCTION_NODE))
{
return false;
}
else
 {
var ch=this.children();
if (ch)
{
var i;
for (i=0; i<ch.length(); i++)
{
if (ch.elementByIndex(i).type() == this.ELEMENT_NODE)
{
return false;
}
}
}
return true;
}
}
HxG_6.prototype.XMLData.prototype.isWhitespaceChar=function(s)
{
return (s==' ' || s=='\n' || s=='\t' || s=='\r');
}
HxG_6.prototype.XMLData.prototype.trimWhitespace=function(s)
{
if (!s)
{
return "";
}
else
 {
var i=0,j=(s.length-1);
while(i<s.length&&this.isWhitespaceChar(s.charAt(i)))
{
i++;
}
while(j>i&&this.isWhitespaceChar(s.charAt(j)))
{
j--;
}
var str=s.substring(i,j+1);
return str;
}
}
HxG_6.prototype.XMLData.prototype.EscapeElementValue=function(s)
{
var str="", i;
for (i=0; i<s.length; i++)
{
var curr=s.charAt(i);
switch (curr)
{
case '<':
str+="&lt;";
break;
case '>':
str+="&gt";
break;
case '&':
str+="&amp";
break;
default:
str+=curr;
break;
}
}
return str;
}
HxG_6.prototype.XMLData.prototype.EscapeAttributeValue=function(s)
{
var str="", i;
for (i=0; i<s.length; i++)
{
var curr=s.charAt(i);
switch (curr)
{
case '"':
str+="&quot;";
break;
case '<':
str+="&lt";
break;
case '&':
str+="&amp";
break;
case '\u000A':
str+="&#xA;";
break;
case '\u000D':
str+="&#xD;";
break;
case '\u0009':
str+="&#x9;";
break;
default:
str+=curr;
break;
}
}
return str;
}
HxG_6.prototype.XMLData.prototype.destroy=function()
{
this.xmlNode=null;
}
HxG_6.prototype.XMLDataList=function(values)
{
this.xmlDataArray=[];
if (values)
{
var i;
for(i=0; i< values.length; i++)
{
if(values[i] instanceof hX_6.XMLData)
{
this.xmlDataArray[i]=values[i];
}
else if (values[i].nodeType)
{
this.xmlDataArray[i]=new hX_6.XMLData(values[i]);
}
else
 {
var args=[];
args[0]="values[" + i + "]";
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_param_type, args);
Log.error("HxG_6.XMLDataList", Msg);
throw new hX_6.XMLDataError(Msg);
}
}
}
}
HxG_6.prototype.XMLDataList.prototype.attribute=function(attributeName)
{
if (attributeName)
{
var i,j=0, attrs=[];
for (i=0; i<this.xmlDataArray.length; i++)
{
if (this.xmlDataArray[i].type() == this.xmlDataArray[i].ELEMENT_NODE)
{
var curr=this.xmlDataArray[i].attribute(attributeName);
if(curr){
attrs[j]=curr;
j++;
}
}
}
return new hX_6.XMLDataList(attrs);
}
else
 {
var args=[];
args[0]="attributeName";
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_param, args);
Log.error("HxG_6.XMLData.attribute", Msg);
throw new hX_6.XMLDataError(Msg);
return null;
}
}
HxG_6.prototype.XMLDataList.prototype.elementByIndex=function(index)
{
if(index < this.xmlDataArray.length && index >= 0)
{
return this.xmlDataArray[index];
}
else
 {
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_index);
Log.error("HxG_6.XMLData.elementByIndex", Msg);
throw new hX_6.XMLDataError(Msg);
}
}
HxG_6.prototype.XMLDataList.prototype.attributes=function()
{
var arr=[], i, result;
for (i=0; i<this.xmlDataArray.length; i++)
{
arr[i]=this.xmlDataArray[i].attributes();
if(i==0)
{
result=arr[i];
}
else
 {
result.append(arr[i]);
}
}
return result;
}
HxG_6.prototype.XMLDataList.prototype.append=function(y)
{
if(!y)
{
var args=[];
args[0]="y";
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_param, args);
Log.error("HxG_6.XMLDataList.append", Msg);
throw new hX_6.XMLDataError(Msg);
}
else
 {
var i;
if(y instanceof hX_6.XMLData)
{
this.xmlDataArray[this.xmlDataArray.length]=y;
}
else if(y instanceof hX_6.XMLDataList)
{
for (i=0; i<(y.length()); i++)
{
this.xmlDataArray[this.xmlDataArray.length]=y.elementByIndex(i);
}
}
else
 {
var args=[];
args[0]="y";
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_param_type, args);
Log.error("HxG_6.XMLDataList.append", Msg);
throw new hX_6.XMLDataError(Msg);
}
}
}
HxG_6.prototype.XMLDataList.prototype.child=function(propertyName)
{
if (propertyName)
{
var i, result=new hX_6.XMLDataList();
for (i=0; i<this.length(); i++)
{
var ch=this.elementByIndex(i).child(propertyName);
if(ch!=null)
{
result.append(ch);
}
}
return result;
}
else
 {
var args=[];
args[0]="propertyName";
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_param, args);
Log.error("HxG_6.XMLDataList.child", Msg);
throw new hX_6.XMLDataError(Msg);
return null;
}
}
HxG_6.prototype.XMLDataList.prototype.children=function()
{
var i, result=new hX_6.XMLDataList();
for (i=0; i<this.length(); i++)
{
var ch=this.elementByIndex(i).children();
if(ch!=null)
{
result.append(ch);
}
}
return result;
}
HxG_6.prototype.XMLDataList.prototype.contains=function(value)
{
var i;
if(value)
{
for (i=0; i<this.length(); i++)
{
if (value.contains(this.xmlDataArray[i]))
{
return true;
}
}
return false;
}
else
 {
var args=[];
args[0]="value";
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_param, args);
Log.error("HxG_6.XMLDataList.contains", Msg);
throw new hX_6.XMLDataError(Msg);
}
}
HxG_6.prototype.XMLDataList.prototype.elements=function(name)
{
var i, result=new hX_6.XMLDataList(), elems;
for (i=0; i<this.length(); i++)
{
if(name)
{
elems=this.elementByIndex(i).elements(name);
}
else
 {
elems=this.elementByIndex(i).elements();
}
if(elems!=null)
{
result.append(elems);
}
}
return result;
}
HxG_6.prototype.XMLDataList.prototype.length=function()
{
var len=this.xmlDataArray.length;
return len;
}
HxG_6.prototype.XMLDataList.prototype.remove=function(P)
{
if (typeof P == "number")
{
if (P >= this.length())
{
var args=[];
args[0]="P";
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_index, args);
Log.error("HxG_6.XMLDataList.remove", Msg);
throw new hX_6.XMLDataError(Msg);
}
else
 {
var curr=this.elementByIndex(P);
if (curr.xmlNode.parentNode)
{
var parent=new hX_6.XMLData(this.xmlDataArray[P].xmlNode.parentNode);
if (curr.type() == curr.ATTRIBUTE_NODE)
{
parent.remove("@"+curr.name());
}
else
 {
parent.xmlNode.removeChild(curr.xmlNode);
var k;
for (k=P; k<(this.length()-1); k++)
{
this.xmlDataArray[k]=this.xmlDataArray[k+1];
}
this.xmlDataArray[this.xmlDataArray.length-1]=null;
this.xmlDataArray.length--;
}
}
}
}
else if(typeof P == "string")
{
var i;
for (i=0; i<this.length(); i++)
{
var curr=this.elementByIndex(i);
if (curr.type() == curr.ELEMENT_NODE)
{
curr.remove(P);
}
}
}
else
 {
var args=[];
args[0]="P";
var Msg=hX_6.NLSFormatMsg(hX_6.INTERR_invalid_param_type, args);
Log.error("HxG_6.XMLDataList.remove", Msg);
throw new hX_6.XMLDataError(Msg);
}
}
HxG_6.prototype.XMLDataList.prototype.text=function()
{
var str="", i;
for(i=0; i<this.length(); i++)
{
str+=this.xmlDataArray[i].text();
}
return str;
}
HxG_6.prototype.XMLDataList.prototype.toString=function()
{
if (this.hasSimpleContent())
{
var s="", i;
for (i=0; i<this.length(); i++)
{
var curr=this.xmlDataArray[i];
var t=curr.type();
if ((t != curr.COMMENT_NODE) && (t != curr.PROCESSING_INSTRUCTION_NODE))
{
s+=curr.toString();
}
}
return s;
}
else
 {
return this.toXMLString();
}
}
HxG_6.prototype.XMLDataList.prototype.toXMLString=function()
{
var i, str="";
for (i=0; i<this.length(); i++)
{
var curr=this.xmlDataArray[i];
if ((curr.prettyPrinting == true) && (i!=0))
{
str+="\n";
}
str+=curr.toXMLString();
}
return str;
}
HxG_6.prototype.XMLDataList.prototype.toArrayOfXMLData=function()
{
var arr=[], i;
for(i=0; i<this.xmlDataArray[i]; i++){
arr[i]=this.xmlDataArray[i].copy(true);
}
return arr;
}
HxG_6.prototype.XMLDataList.prototype.hasSimpleContent=function()
{
if (this.length() == 0)
{
return true;
}
else if (this.length() == 1)
{
return this.xmlDataArray[0].hasSimpleContent();
}
else
 {
var i;
for (i=0; i<this.length(); i++)
{
if(this.xmlDataArray[i].type() == this.xmlDataArray[i].ELEMENT_NODE)
{
return false;
}
}
}
return true;
}
HxG_6.prototype.XMLDataList.prototype.copy=function()
{
var i, arr=[];
for (i=0; i<this.length(); i++)
{
arr[arr.length]=this.xmlDataArray[i].copy();
}
return new XMLDataList(arr);
}
HxG_6.prototype.XMLDataList.prototype.destroy=function()
{
for (i=0; i<this.length(); i++)
{
this.xmlDataArray[i].destroy();
this.xmlDataArray[i]=null;
}
this.xmlDataArray=null;
}
HxG_6.prototype.XMLDataError=function(d)
{
this.description=d;
this.toString=function () { return d; }
}
