/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.webapp;

import com.ibm.faces.renderkit.html_extended.HxClientRenderUtil;
import com.ibm.faces.util.LifecycleUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JSResourceServlet
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = -4384407003696299574L;
    private ClassLoader classLoader = null;
    private HashMap cache = null;
    private long startTime = -1L;
    private static final String PATH_PREFIX = "ibmjsfres";
    private String URLPattern = null;
    private Long expires = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block43: {
            InputStream stream = null;
            byte[] buffer = new byte[10000];
            String uri = req.getRequestURI();
            if (this.URLPattern == null) {
                this.URLPattern = LifecycleUtil.getJSResourceURLPattern(this.getServletContext().getInitParameter("com.ibm.faces.JS_RESOURCE_SERVLET_URL_PATTERN"));
            }
            uri = PATH_PREFIX + uri.substring(uri.lastIndexOf(this.URLPattern) + this.URLPattern.length());
            long ifModSince = -1L;
            try {
                ifModSince = req.getDateHeader("If-Modified-Since");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (ifModSince >= this.startTime) {
                resp.setStatus(304);
                return;
            }
            try {
                Object resMap;
                Object localeStr;
                resp.setDateHeader("Last-Modified", this.startTime);
                resp.setHeader("Content-Type", this.getServletContext().getMimeType(uri));
                if (this.expires == null) {
                    String expiresParam = this.getServletContext().getInitParameter("com.ibm.faces.RESOURCE_EXPIRE_MS");
                    if (expiresParam != null) {
                        this.expires = Long.valueOf(expiresParam);
                        if (this.expires > 31536000000L) {
                            this.expires = Long.valueOf("31536000000");
                        }
                    } else {
                        this.expires = Long.valueOf("31536000000");
                    }
                }
                resp.setDateHeader("Expires", this.startTime + this.expires);
                String extrafile = null;
                if (uri.indexOf("/hxclient_S_") > 0) {
                    Locale locale = null;
                    localeStr = req.getParameter("viewLocale");
                    if (localeStr == null) {
                        String resName = "hxclient_S_v3_1_3";
                        if (uri.indexOf(resName + ".js") > -1) {
                            localeStr = "en";
                        } else if (uri.indexOf(resName + "_") > -1) {
                            int i = uri.indexOf(resName);
                            localeStr = uri.substring(i + (resName.length() + 1), uri.indexOf(".js", i));
                        }
                    }
                    if (localeStr != null && ((String)localeStr).length() > 1) {
                        locale = ((String)(localeStr = ((String)localeStr).trim())).indexOf(95) > -1 ? new Locale(((String)localeStr).substring(0, 2), ((String)localeStr).substring(3)) : new Locale((String)localeStr, "");
                        boolean bValidLocale = false;
                        Locale[] availableLocales = Locale.getAvailableLocales();
                        for (int i = 0; i < availableLocales.length; ++i) {
                            if (!locale.equals(availableLocales[i])) continue;
                            bValidLocale = true;
                            break;
                        }
                        if (!bValidLocale) {
                            locale = req.getLocale();
                        }
                    } else {
                        locale = req.getLocale();
                    }
                    resMap = (Map)this.getServletContext().getAttribute("com.ibm.faces.HX_STRING_RESOURCES");
                    if (resMap != null) {
                        extrafile = (String)resMap.get(locale.toString());
                    }
                    if (extrafile == null) {
                        extrafile = HxClientRenderUtil.generateStringResources(locale, resMap);
                    }
                    if (extrafile != null) {
                        byte[] bfile = extrafile.getBytes();
                        resp.getOutputStream().write(bfile);
                        return;
                    }
                }
                if (this.cache != null) {
                    boolean bInCache;
                    localeStr = this;
                    synchronized (localeStr) {
                        bInCache = this.cache.containsKey(uri);
                    }
                    if (bInCache) {
                        byte[] bytes;
                        resMap = this;
                        synchronized (resMap) {
                            bytes = (byte[])this.cache.get(uri);
                        }
                        resp.getOutputStream().write(bytes);
                        return;
                    }
                }
                if ((stream = this.classLoader.getResourceAsStream(uri)) != null) {
                    if (this.cache == null) {
                        int read = 0;
                        while ((read = stream.read(buffer)) > 0) {
                            resp.getOutputStream().write(buffer, 0, read);
                        }
                        break block43;
                    }
                    byte[] bytes = new byte[]{};
                    int read = 0;
                    while ((read = stream.read(buffer)) > 0) {
                        int newSize = bytes.length + read;
                        byte[] newBytes = new byte[newSize];
                        System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
                        System.arraycopy(buffer, 0, newBytes, bytes.length, read);
                        bytes = newBytes;
                    }
                    resp.getOutputStream().write(bytes);
                    JSResourceServlet jSResourceServlet = this;
                    synchronized (jSResourceServlet) {
                        this.cache.put(uri, bytes);
                        break block43;
                    }
                }
                throw new FileNotFoundException("JSRServlet: " + uri + " could not be found");
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        String cacheParam = config.getInitParameter("com.ibm.faces.JS_RESOURCE_SERVLET_CACHE");
        if (cacheParam == null) {
            cacheParam = config.getInitParameter("cache");
        }
        if (cacheParam != null && cacheParam.equalsIgnoreCase("true")) {
            this.cache = new HashMap();
        }
        this.startTime = System.currentTimeMillis() / 1000L * 1000L;
    }

    public void destroy() {
        if (this.cache != null) {
            this.cache.clear();
        }
        super.destroy();
    }
}

