/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.validator;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.util.FacesMessageUtil;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class ModulusSelfCheckValidator
implements Validator,
StateHolder {
    private static String _validatorMessage = "validatorMessage";
    private String modulus;

    public String getModulus() {
        return this.modulus;
    }

    public void setModulus(String modulus) {
        this.modulus = modulus;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        int digit;
        int i;
        if (value == null) {
            return;
        }
        ResourceBundle rb = null;
        FacesMessage errMsg = null;
        if (this.modulus == null || !this.modulus.equals("10") && !this.modulus.equals("11")) {
            rb = ResourceHandler.getBundle(context);
            errMsg = this.getFacesMessage(rb, FacesMessage.SEVERITY_ERROR, "ValidationMessage.validation_error", "ModulusSelfCheckValidator.incorrect_modulus_setting", component, value);
            this.setInvalid(context, component, errMsg);
            return;
        }
        String strValue = null;
        if (value instanceof Integer || value instanceof Long) {
            strValue = value.toString();
        }
        if (value instanceof String) {
            strValue = (String)value;
        }
        StringBuffer buf = new StringBuffer();
        for (int x = 0; x < strValue.length(); ++x) {
            if (!Character.isDigit(strValue.charAt(x))) continue;
            buf.append(strValue.charAt(x));
        }
        strValue = buf.toString();
        if (strValue == null || strValue.length() < 2) {
            rb = ResourceHandler.getBundle(context);
            errMsg = this.getFacesMessage(rb, FacesMessage.SEVERITY_ERROR, ResourceHandler.getFacesMessageString(rb, "ValidationMessage.validation_error"), ResourceHandler.getFacesMessageString(rb, "ModulusSelfCheckValidator.invalid_value"), component, value);
            this.setInvalid(context, component, errMsg);
            return;
        }
        char checkDigit = strValue.charAt(strValue.length() - 1);
        strValue = strValue.substring(0, strValue.length() - 1);
        int sum = 0;
        int result = -1;
        if (this.modulus.equals("10")) {
            boolean odd = true;
            for (i = strValue.length() - 1; i >= 0; --i) {
                digit = Character.getNumericValue(strValue.charAt(i));
                if (odd) {
                    sum += digit < 5 ? digit * 2 : (digit - 5) * 2 + 1;
                    odd = false;
                    continue;
                }
                sum += digit;
                odd = true;
            }
            result = 10 - sum % 10;
        }
        if (this.modulus.equals("11")) {
            int weight = 2;
            for (i = strValue.length(); i > 0; --i) {
                digit = Character.getNumericValue(strValue.charAt(i - 1));
                sum += digit * weight;
                weight = weight >= 7 ? 2 : weight + 1;
            }
            int n = result = sum % 11 == 0 ? 0 : 11 - sum % 11;
        }
        if (result != Character.getNumericValue(checkDigit)) {
            rb = ResourceHandler.getBundle(context);
            errMsg = this.getFacesMessage(rb, FacesMessage.SEVERITY_ERROR, "ValidationMessage.validation_error", "ModulusSelfCheckValidator.invalid_value", component, value);
            this.setInvalid(context, component, errMsg);
            return;
        }
    }

    private void setInvalid(FacesContext context, UIComponent component, FacesMessage errorMessage) {
        context.addMessage(component.getClientId(context), errorMessage);
        ((UIInput)component).setValid(false);
        throw new ValidatorException(errorMessage);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.modulus};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.modulus = (String)values[0];
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean arg0) {
    }

    protected FacesMessage getFacesMessage(ResourceBundle rb, FacesMessage.Severity severity, String summaryKey, String detailKey, UIComponent component, Object value) {
        return FacesMessageUtil.getValidatorFacesMessage(rb, severity, summaryKey, detailKey, component, value);
    }
}

