/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.validator;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.util.FacesMessageUtil;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class ExpressionValidator
implements Validator,
StateHolder {
    private static String _validatorMessage = "validatorMessage";
    public static String ALPHABET_ONLY_MESSAGE;
    public static String DIGIT_ONLY_MESSAGE;
    public static String ALPHABET_NUMBER_ONLY_MESSAGE;
    public static String REGEX_IS_INVALID_MESSAGE;
    public static String NULL_MESSAGE;
    private String expression;
    private ResourceBundle rb;
    private boolean transientFlag = false;

    public ExpressionValidator() {
    }

    public ExpressionValidator(String exp) {
        this.setExpression(exp);
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (value == null) {
            return;
        }
        if (this.expression == null || this.expression.length() == 0) {
            return;
        }
        this.rb = ResourceHandler.getBundle(context);
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        boolean bValid = true;
        FacesMessage errMsg = null;
        String expressionValueKey = component.getClientId(context) + "_exp_val";
        expressionValueKey = expressionValueKey.replace(':', '_');
        context.getExternalContext().getRequestMap().put(expressionValueKey, value);
        int i = this.expression.indexOf("value");
        if (i > -1) {
            StringBuffer buf = new StringBuffer();
            int pos = 0;
            while (i > -1) {
                if (Character.isJavaIdentifierStart(this.expression.charAt(i - 1)) || Character.isJavaIdentifierPart(this.expression.charAt(i + 5)) || this.expression.charAt(i - 1) == '\'' || this.expression.charAt(i + 5) == '\'') {
                    buf.append(this.expression.substring(pos, i + 5));
                    pos = i + 5;
                } else {
                    buf.append(this.expression.substring(pos, i)).append("requestScope.").append(expressionValueKey);
                    pos = i + 5;
                }
                i = this.expression.indexOf("value", pos);
            }
            buf.append(this.expression.substring(pos));
            this.expression = buf.toString();
        }
        Object result = null;
        try {
            result = context.getApplication().createValueBinding(this.expression).getValue(context);
        }
        catch (EvaluationException e) {
            errMsg = this.getFacesMessage(this.rb, FacesMessage.SEVERITY_ERROR, "ExpressionValidator.ValidationError", "ExpressionValidator.InvalidExpression", component, null);
            bValid = false;
        }
        if (!(result instanceof Boolean)) {
            errMsg = this.getFacesMessage(this.rb, FacesMessage.SEVERITY_ERROR, "ExpressionValidator.ValidationError", "ExpressionValidator.NotBoolean", component, null);
            bValid = false;
        } else {
            Boolean bResult = (Boolean)result;
            if (bResult != Boolean.TRUE) {
                errMsg = this.getFacesMessage(this.rb, FacesMessage.SEVERITY_ERROR, "ExpressionValidator.ValidationError", "ExpressionValidator.FalseExpression", component, null);
                bValid = false;
            }
        }
        if (!bValid) {
            context.addMessage(component.getClientId(context), errMsg);
            ((UIInput)component).setValid(false);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.expression};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.expression = (String)values[0];
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean newTransientValue) {
        this.transientFlag = newTransientValue;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    protected FacesMessage getFacesMessage(ResourceBundle rb, FacesMessage.Severity severity, String summaryKey, String detailKey, UIComponent component, Object value) {
        return FacesMessageUtil.getValidatorFacesMessage(rb, severity, summaryKey, detailKey, component, value);
    }
}

