/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.validator;

import com.ibm.faces.ResourceHandler;
import com.ibm.faces.util.FacesMessageUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.DateTimeConverter;
import javax.faces.validator.Validator;

public class DateTimeRangeValidator
implements Validator,
StateHolder {
    private static String _validatorMessage = "validatorMessage";
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MINIMUM";
    private Date minimum = null;
    private Date maximum = null;
    private boolean minimumSet = false;
    private boolean maximumSet = false;
    private boolean transientValue = false;

    public DateTimeRangeValidator() {
    }

    public DateTimeRangeValidator(Date maximum) {
        this.setMaximum(maximum);
    }

    public DateTimeRangeValidator(Date maximum, Date minimum) {
        this.setMaximum(maximum);
        this.setMinimum(minimum);
    }

    public Date getMaximum() {
        return this.isMaximumSet() ? this.maximum : null;
    }

    public void setMaximum(Date newMaximum) {
        this.maximum = newMaximum;
        this.maximumSet = true;
    }

    public boolean isMaximumSet() {
        return this.maximumSet;
    }

    public Date getMinimum() {
        return this.isMinimumSet() ? this.minimum : null;
    }

    public void setMinimum(Date newMinimum) {
        this.minimum = newMinimum;
        this.minimumSet = true;
    }

    public boolean isMinimumSet() {
        return this.minimumSet;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws FacesException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Date convertedValue = null;
        if (value != null) {
            if (value instanceof Date) {
                convertedValue = (Date)value;
            } else if (value instanceof Long) {
                convertedValue = new Date((Long)value);
            } else {
                throw new FacesException("Validation Error: Specified attribute cannot be converted to proper type.");
            }
            this.calculateTimeAndPrintErrors(convertedValue, context, (UIInput)component);
        }
    }

    protected String stringValue(Object attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        if (attributeValue instanceof String) {
            return (String)attributeValue;
        }
        return attributeValue.toString();
    }

    protected void calculateTimeAndPrintErrors(Date convertedValue, FacesContext context, UIInput component) {
        ResourceBundle bundle;
        Calendar cal;
        FacesMessage errMsg = null;
        Date minDate = null;
        Date maxDate = null;
        DateTimeConverter dtconverter = null;
        if (component.getConverter() instanceof DateTimeConverter) {
            dtconverter = (DateTimeConverter)component.getConverter();
        }
        if (this.isMinimumSet()) {
            if (dtconverter != null && dtconverter.getType().equalsIgnoreCase("time") && this.getMinimum().getTime() > 86400000L) {
                cal = Calendar.getInstance();
                cal.setTime(this.getMinimum());
                cal.set(1970, 0, 1);
                minDate = cal.getTime();
            } else {
                minDate = this.getMinimum();
            }
        }
        if (this.isMaximumSet()) {
            if (dtconverter != null && dtconverter.getType().equalsIgnoreCase("time") && this.getMaximum().getTime() > 86400000L) {
                cal = Calendar.getInstance();
                cal.setTime(this.getMaximum());
                cal.set(1970, 0, 1);
                maxDate = cal.getTime();
            }
            maxDate = this.getMaximum();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        if (minDate != null && convertedValue.before(minDate)) {
            bundle = ResourceHandler.getBundle(context);
            errMsg = this.getFacesMessage(bundle, FacesMessage.SEVERITY_ERROR, "ValidationMessage.less_than_minimum", null, (UIComponent)component, sdf.format(minDate));
            context.addMessage(component.getClientId(context), errMsg);
            component.setValid(false);
        }
        if (maxDate != null && convertedValue.after(maxDate)) {
            bundle = ResourceHandler.getBundle(context);
            errMsg = this.getFacesMessage(bundle, null, "ValidationMessage.more_than_maximum", null, (UIComponent)component, sdf.format(maxDate));
            context.addMessage(component.getClientId(context), errMsg);
            component.setValid(false);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.maximum, this.maximumSet ? Boolean.TRUE : Boolean.FALSE, this.minimum, this.minimumSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.maximum = (Date)values[0];
        this.maximumSet = (Boolean)values[1];
        this.minimum = (Date)values[2];
        this.minimumSet = (Boolean)values[3];
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    protected FacesMessage getFacesMessage(ResourceBundle rb, FacesMessage.Severity severity, String summaryKey, String detailKey, UIComponent component, Object value) {
        return FacesMessageUtil.getValidatorFacesMessage(rb, severity, summaryKey, detailKey, component, value);
    }
}

