/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.faces.util;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class ResponseWriterBuffer {
    private StringBuffer sb = new StringBuffer();
    private boolean TagOpen;
    private boolean SimpleTag;

    public String toString() {
        return this.sb.toString();
    }

    public void write(String s) {
        this.sb.append(s);
    }

    public void startElement(String name, UIComponent component) throws IOException {
        String outName = name.toLowerCase();
        this.checkTagOpenState();
        if (outName.equals("br") || outName.equals("hr") || outName.equals("input)")) {
            this.setSimpleTag(true);
        } else {
            this.setSimpleTag(false);
        }
        this.sb.append("<" + name + " ");
        this.setTagOpen(true);
    }

    public void endElement(String name) throws IOException {
        this.checkTagOpenState();
        this.sb.append("</").append(name).append(">");
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (this.isTagOpen()) {
            this.sb.append(name).append("=\"").append(value.toString()).append("\" ");
        }
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (this.isTagOpen()) {
            this.sb.append(name).append("=\"").append(FacesContext.getCurrentInstance().getExternalContext().encodeResourceURL(value.toString())).append("\" ");
        }
    }

    public void writeComment(Object comment) throws IOException {
        this.checkTagOpenState();
        this.sb.append("<!-- ").append(comment.toString()).append(" -->");
    }

    public void writeText(Object text, String property) throws IOException {
        this.checkTagOpenState();
        this.sb.append(text.toString());
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.checkTagOpenState();
        this.sb.append(text, off, len);
    }

    private boolean isSimpleTag() {
        return this.SimpleTag;
    }

    private void setSimpleTag(boolean simpleTag) {
        this.SimpleTag = simpleTag;
    }

    private boolean isTagOpen() {
        return this.TagOpen;
    }

    private void setTagOpen(boolean tagOpen) {
        this.TagOpen = tagOpen;
    }

    public void checkTagOpenState() {
        if (this.isTagOpen()) {
            if (this.isSimpleTag()) {
                this.sb.append(" /");
            }
            this.sb.append(">");
            this.setTagOpen(false);
        }
    }

    public void clearBuffer() {
        this.sb.delete(0, this.sb.length());
    }
}

